/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class AddSerialVersionUidToSerializable
extends Recipe {
    public String getDisplayName() {
        return "Add `serialVersionUID` to a `Serializable` class when missing";
    }

    public String getDescription() {
        return "A `serialVersionUID` field is strongly recommended in all `Serializable` classes. If this is not defined on a `Serializable` class, the compiler will generate this value. If a change is later made to the class, the generated value will change and attempts to deserialize the class will fail.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2057");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), "private static final long serialVersionUID = 1;").build();

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                return method;
            }

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
                if (!this.implementsSerializable(((J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class)).getType())) {
                    return multiVariable;
                }
                J varDecls = super.visitVariableDeclarations(multiVariable, executionContext);
                for (J.VariableDeclarations.NamedVariable v : ((J.VariableDeclarations)varDecls).getVariables()) {
                    if (!"serialVersionUID".equals(v.getSimpleName())) continue;
                    this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).putMessage("has-serial-version-id", (Object)Boolean.TRUE);
                    varDecls = this.maybeFixVariableDeclarations((J.VariableDeclarations)varDecls);
                    if (multiVariable == varDecls) break;
                    varDecls = (J.VariableDeclarations)this.maybeAutoFormat(multiVariable, varDecls, executionContext, this.getCursor().getParentOrThrow());
                    break;
                }
                return varDecls;
            }

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J c = super.visitClassDeclaration(classDecl, ctx);
                Boolean needsSerialVersionId = (Boolean)this.getCursor().pollMessage("has-serial-version-id");
                if (needsSerialVersionId == null && this.implementsSerializable(((J.ClassDeclaration)c).getType())) {
                    c = (J.ClassDeclaration)c.withTemplate(this.template, ((J.ClassDeclaration)c).getBody().getCoordinates().firstStatement(), new Object[0]);
                }
                return c;
            }

            private J.VariableDeclarations maybeFixVariableDeclarations(J.VariableDeclarations varDecls) {
                JavaType.Primitive variableType;
                List<J.Modifier> modifiers = varDecls.getModifiers();
                if (!(J.Modifier.hasModifier(modifiers, J.Modifier.Type.Private) && J.Modifier.hasModifier(modifiers, J.Modifier.Type.Static) && J.Modifier.hasModifier(modifiers, J.Modifier.Type.Final))) {
                    varDecls = varDecls.withModifiers(Arrays.asList(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Private, Collections.emptyList()), new J.Modifier(Tree.randomId(), Space.format(" "), Markers.EMPTY, J.Modifier.Type.Static, Collections.emptyList()), new J.Modifier(Tree.randomId(), Space.format(" "), Markers.EMPTY, J.Modifier.Type.Final, Collections.emptyList())));
                }
                if ((variableType = TypeUtils.asPrimitive(varDecls.getType())) != JavaType.Primitive.Long) {
                    varDecls = varDecls.withTypeExpression(new J.Primitive(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JavaType.Primitive.Long));
                }
                return varDecls;
            }

            private boolean implementsSerializable(@Nullable JavaType type) {
                if (type == null) {
                    return false;
                }
                if (type instanceof JavaType.Primitive) {
                    return true;
                }
                if (type instanceof JavaType.Array) {
                    return this.implementsSerializable(((JavaType.Array)type).getElemType());
                }
                if (type instanceof JavaType.Parameterized) {
                    JavaType.Parameterized parameterized = (JavaType.Parameterized)type;
                    if (parameterized.isAssignableTo("java.util.Collection") || parameterized.isAssignableTo("java.util.Map")) {
                        boolean typeParametersSerializable = true;
                        for (JavaType typeParameter : parameterized.getTypeParameters()) {
                            typeParametersSerializable = typeParametersSerializable && this.implementsSerializable(typeParameter);
                        }
                        return typeParametersSerializable;
                    }
                } else if (type instanceof JavaType.FullyQualified) {
                    JavaType.FullyQualified fq = (JavaType.FullyQualified)type;
                    if (fq.getKind() == JavaType.FullyQualified.Kind.Enum) {
                        return false;
                    }
                    if (fq.getKind() != JavaType.FullyQualified.Kind.Interface && !fq.isAssignableTo("java.lang.Throwable")) {
                        return fq.isAssignableTo("java.io.Serializable");
                    }
                }
                return false;
            }
        };
    }
}

