/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.dataflow.MethodMatcherCache;
import org.openrewrite.java.dataflow.internal.InvocationMatcher;
import org.openrewrite.java.dataflow.internal.csv.CsvLoader;
import org.openrewrite.java.dataflow.internal.csv.GenericExternalModel;
import org.openrewrite.java.dataflow.internal.csv.Mergeable;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Incubating(since="7.25.0")
public final class ExternalSinkModels {
    private static final String CURSOR_MESSAGE_KEY = "OPTIMIZED_SINK_MODELS";
    private static final ExternalSinkModels instance = new ExternalSinkModels();
    private WeakReference<FullyQualifiedNameToSinkModels> fullyQualifiedNameToSinkModel;

    public static ExternalSinkModels getInstance() {
        return instance;
    }

    private FullyQualifiedNameToSinkModels getFullyQualifiedNameToSinkModel() {
        FullyQualifiedNameToSinkModels f;
        if (this.fullyQualifiedNameToSinkModel == null) {
            f = Loader.load();
            this.fullyQualifiedNameToSinkModel = new WeakReference<FullyQualifiedNameToSinkModels>(f);
        } else {
            f = (FullyQualifiedNameToSinkModels)this.fullyQualifiedNameToSinkModel.get();
            if (f == null) {
                f = Loader.load();
                this.fullyQualifiedNameToSinkModel = new WeakReference<FullyQualifiedNameToSinkModels>(f);
            }
        }
        return f;
    }

    private OptimizedSinkModels getOptimizedSinkModelsForTypesInUse(TypesInUse typesInUse) {
        return Optimizer.optimize(this.getFullyQualifiedNameToSinkModel().forTypesInUse(typesInUse));
    }

    private OptimizedSinkModels getOrComputeOptimizedSinkModels(Cursor cursor) {
        Cursor cuCursor = cursor.dropParentUntil(J.CompilationUnit.class::isInstance);
        return (OptimizedSinkModels)cuCursor.computeMessageIfAbsent(CURSOR_MESSAGE_KEY, __ -> this.getOptimizedSinkModelsForTypesInUse(((J.CompilationUnit)cuCursor.getValue()).getTypesInUse()));
    }

    public boolean isSinkNode(Expression expression, Cursor cursor, String kind) {
        return this.getOrComputeOptimizedSinkModels(cursor).forKind(kind).stream().anyMatch(predicate -> predicate.isSinkNode(expression, cursor));
    }

    private ExternalSinkModels() {
    }

    static class Loader {
        Loader() {
        }

        static FullyQualifiedNameToSinkModels load() {
            return CsvLoader.loadFromFile("sinks.csv", FullyQualifiedNameToSinkModels.empty(), Loader::createFullyQualifiedNameToFlowModels, tokens -> new SinkModel(tokens[0], tokens[1], Boolean.parseBoolean(tokens[2]), tokens[3], tokens[4], tokens[5], tokens[6], tokens[7], Boolean.parseBoolean(tokens[8])));
        }

        private static FullyQualifiedNameToSinkModels createFullyQualifiedNameToFlowModels(Iterable<SinkModel> sinkModels) {
            HashMap<String, List<SinkModel>> fqnToSinkModels = new HashMap<String, List<SinkModel>>();
            for (SinkModel sinkModel : sinkModels) {
                fqnToSinkModels.computeIfAbsent(sinkModel.getFullyQualifiedName(), k -> new ArrayList()).add(sinkModel);
            }
            return new FullyQualifiedNameToSinkModels(fqnToSinkModels);
        }
    }

    static class FullyQualifiedNameToSinkModels
    implements Mergeable<FullyQualifiedNameToSinkModels> {
        private final Map<String, List<SinkModel>> fqnToSinkModels;

        boolean isEmpty() {
            return this.fqnToSinkModels.isEmpty();
        }

        @Override
        public FullyQualifiedNameToSinkModels merge(FullyQualifiedNameToSinkModels other) {
            if (other.isEmpty()) {
                return this;
            }
            if (this.isEmpty()) {
                return other;
            }
            HashMap<String, List<SinkModel>> merged = new HashMap<String, List<SinkModel>>(this.fqnToSinkModels);
            other.fqnToSinkModels.forEach((k, v) -> merged.computeIfAbsent((String)k, kk -> new ArrayList(v.size())).addAll(v));
            return new FullyQualifiedNameToSinkModels(merged);
        }

        SinkModels forTypesInUse(TypesInUse typesInUse) {
            HashMap<String, Set<SinkModel>> sinkModels = new HashMap<String, Set<SinkModel>>();
            typesInUse.getUsedMethods().stream().map(JavaType.Method::getDeclaringType).map(JavaType.FullyQualified::getFullyQualifiedName).distinct().flatMap(fqn -> this.fqnToSinkModels.getOrDefault(fqn, Collections.emptyList()).stream()).forEach(sinkModel -> sinkModels.computeIfAbsent(sinkModel.kind, k -> new HashSet(1)).add(sinkModel));
            return new SinkModels(sinkModels);
        }

        static FullyQualifiedNameToSinkModels empty() {
            return new FullyQualifiedNameToSinkModels(new HashMap<String, List<SinkModel>>(0));
        }

        public FullyQualifiedNameToSinkModels(Map<String, List<SinkModel>> fqnToSinkModels) {
            this.fqnToSinkModels = fqnToSinkModels;
        }
    }

    static class SinkModels {
        Map<String, Set<SinkModel>> sinkModels;

        public SinkModels(Map<String, Set<SinkModel>> sinkModels) {
            this.sinkModels = sinkModels;
        }
    }

    private static class Optimizer {
        private final MethodMatcherCache methodMatcherCache = MethodMatcherCache.create();

        private Optimizer() {
        }

        private SinkNodePredicate sinkNodePredicateForArgumentIndex(int argumentIndex, Collection<MethodMatcher> methodMatchers) {
            InvocationMatcher invocationMatcher = InvocationMatcher.fromMethodMatchers(methodMatchers);
            return argumentIndex == -1 ? (expression, cursor) -> invocationMatcher.advanced().isSelect(cursor) : (expression, cursor) -> invocationMatcher.advanced().isParameter(cursor, argumentIndex);
        }

        private List<SinkNodePredicate> optimize(Collection<SinkModel> models) {
            HashMap sinkForArgument = new HashMap();
            for (SinkModel model : models) {
                model.getArgumentRange().ifPresent(argumentRange -> {
                    for (int i = argumentRange.getStart(); i <= argumentRange.getEnd(); ++i) {
                        sinkForArgument.computeIfAbsent(i, __ -> new ArrayList()).add(model);
                    }
                });
            }
            return sinkForArgument.entrySet().stream().map(entry -> {
                Collection<MethodMatcher> methodMatchers = this.methodMatcherCache.provideMethodMatchers((Collection)entry.getValue());
                return this.sinkNodePredicateForArgumentIndex((Integer)entry.getKey(), methodMatchers);
            }).collect(Collectors.toList());
        }

        private static OptimizedSinkModels optimize(SinkModels sinkModels) {
            Optimizer optimizer = new Optimizer();
            Map<String, List<SinkNodePredicate>> sinkKindToPredicates = sinkModels.sinkModels.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, List<SinkNodePredicate>>((String)e.getKey(), optimizer.optimize((Collection)e.getValue()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
            return new OptimizedSinkModels(sinkKindToPredicates);
        }
    }

    private static class OptimizedSinkModels {
        private final Map<String, List<SinkNodePredicate>> sinkKindToPredicates;

        private List<SinkNodePredicate> forKind(String kind) {
            return this.sinkKindToPredicates.getOrDefault(kind, Collections.emptyList());
        }

        public OptimizedSinkModels(Map<String, List<SinkNodePredicate>> sinkKindToPredicates) {
            this.sinkKindToPredicates = sinkKindToPredicates;
        }
    }

    private static interface SinkNodePredicate {
        public boolean isSinkNode(Expression var1, Cursor var2);
    }

    static class SinkModel
    implements GenericExternalModel {
        String namespace;
        String type;
        boolean subtypes;
        String name;
        String signature;
        String ext;
        String input;
        String kind;
        boolean generated;

        @Override
        public String getArguments() {
            return this.input;
        }

        public SinkModel(String namespace, String type, boolean subtypes, String name, String signature, String ext, String input, String kind, boolean generated) {
            this.namespace = namespace;
            this.type = type;
            this.subtypes = subtypes;
            this.name = name;
            this.signature = signature;
            this.ext = ext;
            this.input = input;
            this.kind = kind;
            this.generated = generated;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public boolean isSubtypes() {
            return this.subtypes;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSignature() {
            return this.signature;
        }
    }
}

