/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class InlineVariable
extends Recipe {
    public String getDisplayName() {
        return "Inline variable";
    }

    public String getDescription() {
        return "Inline variables when they are immediately used to return.";
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.VariableDeclarations varDec;
                J.VariableDeclarations.NamedVariable identDefinition;
                String identReturned;
                List<Statement> stats;
                J m = super.visitMethodDeclaration(method, ctx);
                J.Block body = ((J.MethodDeclaration)m).getBody();
                if (body != null && (stats = body.getStatements()).size() > 1 && (identReturned = this.identReturned(stats)) != null && stats.get(stats.size() - 2) instanceof J.VariableDeclarations && (identDefinition = (varDec = (J.VariableDeclarations)stats.get(stats.size() - 2)).getVariables().get(0)).getSimpleName().equals(identReturned)) {
                    m = ((J.MethodDeclaration)m).withBody(body.withStatements(ListUtils.map(stats, (i, stat) -> {
                        if (i == stats.size() - 2) {
                            return null;
                        }
                        if (i == stats.size() - 1) {
                            J.Return retrn = (J.Return)stat;
                            return retrn.withExpression((Expression)Objects.requireNonNull(identDefinition.getInitializer()).withPrefix(Objects.requireNonNull(retrn.getExpression()).getPrefix()));
                        }
                        return stat;
                    })));
                }
                return m;
            }

            @Nullable
            private String identReturned(List<Statement> stats) {
                J.Return retrn;
                if (stats.get(stats.size() - 1) instanceof J.Return && (retrn = (J.Return)stats.get(stats.size() - 1)).getExpression() instanceof J.Identifier) {
                    return ((J.Identifier)retrn.getExpression()).getSimpleName();
                }
                return null;
            }
        };
    }
}

