/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.format.TabsAndIndentsVisitor;
import org.openrewrite.hcl.style.TabsAndIndentsStyle;
import org.openrewrite.hcl.tree.Hcl;

public class TabsAndIndents
extends Recipe {
    public String getDisplayName() {
        return "Tabs and indents";
    }

    public String getDescription() {
        return "Format tabs and indents in HCL code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TabsAndIndentsFromCompilationUnitStyle();
    }

    private static class TabsAndIndentsFromCompilationUnitStyle
    extends HclIsoVisitor<ExecutionContext> {
        private TabsAndIndentsFromCompilationUnitStyle() {
        }

        @Override
        public Hcl.ConfigFile visitConfigFile(Hcl.ConfigFile cf, ExecutionContext ctx) {
            TabsAndIndentsStyle style = (TabsAndIndentsStyle)cf.getStyle(TabsAndIndentsStyle.class);
            if (style == null) {
                style = TabsAndIndentsStyle.DEFAULT;
            }
            return (Hcl.ConfigFile)new TabsAndIndentsVisitor(style).visitNonNull(cf, ctx);
        }
    }
}

