/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy.format;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.format.MergeSpacesVisitor;
import org.openrewrite.groovy.format.MinimumViableSpacingVisitor;
import org.openrewrite.groovy.format.OmitParenthesesForLastArgumentLambdaVisitor;
import org.openrewrite.groovy.format.SpacesVisitor;
import org.openrewrite.java.format.BlankLinesVisitor;
import org.openrewrite.java.format.NormalizeFormatVisitor;
import org.openrewrite.java.format.NormalizeLineBreaksVisitor;
import org.openrewrite.java.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.java.format.RemoveTrailingWhitespaceVisitor;
import org.openrewrite.java.format.TabsAndIndentsVisitor;
import org.openrewrite.java.format.WrappingAndBracesVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class AutoFormatVisitor<P>
extends GroovyIsoVisitor<P> {
    private final @Nullable Tree stopAfter;

    public AutoFormatVisitor() {
        this(null);
    }

    public AutoFormatVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public J visit(@Nullable Tree tree, P p, Cursor cursor) {
        JavaSourceFile cu = tree instanceof JavaSourceFile ? (JavaSourceFile)tree : (JavaSourceFile)cursor.firstEnclosingOrThrow(JavaSourceFile.class);
        tree = new OmitParenthesesForLastArgumentLambdaVisitor(this.stopAfter).visitNonNull(tree, p, cursor.fork());
        J t = (J)new NormalizeFormatVisitor(this.stopAfter).visit(tree, p, cursor.fork());
        t = (J)new BlankLinesVisitor((SourceFile)cu, this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new SpacesVisitor((SourceFile)cu, false, this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new WrappingAndBracesVisitor((SourceFile)cu, this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new NormalizeTabsOrSpacesVisitor((SourceFile)cu, this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = new TabsAndIndentsVisitor((SourceFile)cu, this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new NormalizeLineBreaksVisitor(cu, this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new MinimumViableSpacingVisitor(this.stopAfter).visitNonNull((Tree)t, p, cursor.fork());
        return (J)new MergeSpacesVisitor().visit(tree, t);
    }
}

