/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class MockitoUtils {
    public static J.ClassDeclaration maybeAddMethodWithAnnotation(JavaVisitor visitor, J.ClassDeclaration classDecl, ExecutionContext ctx, boolean isPublic, String methodName, String methodAnnotationSignature, String methodAnnotationToAdd, String additionalClasspathResource, String importToAdd, String methodAnnotationParameters) {
        if (MockitoUtils.hasMethodWithAnnotation(classDecl, new AnnotationMatcher(methodAnnotationSignature))) {
            return classDecl;
        }
        J.MethodDeclaration firstTestMethod = MockitoUtils.getFirstTestMethod(classDecl.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).collect(Collectors.toList()));
        visitor.maybeAddImport(importToAdd);
        String tplStr = methodAnnotationToAdd + methodAnnotationParameters + (isPublic ? " public" : "") + " void " + methodName + "() {}";
        return (J.ClassDeclaration)JavaTemplate.builder((String)tplStr).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{additionalClasspathResource})).imports(new String[]{importToAdd}).build().apply(new Cursor(visitor.getCursor().getParentOrThrow(), (Object)classDecl), firstTestMethod != null ? firstTestMethod.getCoordinates().before() : classDecl.getBody().getCoordinates().lastStatement(), new Object[0]);
    }

    private static boolean hasMethodWithAnnotation(J.ClassDeclaration classDecl, AnnotationMatcher annotationMatcher) {
        for (Statement statement : classDecl.getBody().getStatements()) {
            if (!(statement instanceof J.MethodDeclaration)) continue;
            J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)statement;
            List allAnnotations = methodDeclaration.getAllAnnotations();
            for (J.Annotation annotation : allAnnotations) {
                if (!annotationMatcher.matches(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable J.MethodDeclaration getFirstTestMethod(List<J.MethodDeclaration> methods) {
        for (J.MethodDeclaration methodDeclaration : methods) {
            for (J.Annotation annotation : methodDeclaration.getLeadingAnnotations()) {
                if (!"Test".equals(annotation.getSimpleName())) continue;
                return methodDeclaration;
            }
        }
        return null;
    }
}

