/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Repeat;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.logging.AddLogger;
import org.openrewrite.java.logging.LoggingFramework;
import org.openrewrite.java.logging.ParameterizedLogging;
import org.openrewrite.java.search.FindFieldsOfType;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public final class SystemErrToLogging
extends Recipe {
    private static final MethodMatcher systemErrPrint = new MethodMatcher("java.io.PrintStream print*(String)");
    private static final MethodMatcher printStackTrace = new MethodMatcher("java.lang.Throwable printStackTrace(..)");
    @Option(displayName="Add logger", description="Add a logger field to the class if it isn't already present.", required=false)
    private final @Nullable Boolean addLogger;
    @Option(displayName="Logger name", description="The name of the logger to use when generating a field.", required=false, example="log")
    private final @Nullable String loggerName;
    @Option(displayName="Logging framework", description="The logging framework to use.", valid={"SLF4J", "Log4J1", "Log4J2", "JUL", "COMMONS"}, required=false)
    private final @Nullable String loggingFramework;

    public String getDisplayName() {
        return "Use logger instead of `System.err` print statements";
    }

    public String getDescription() {
        return "Replace `System.err` print statements with a logger.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final LoggingFramework framework = LoggingFramework.fromOption(this.loggingFramework);
        final AnnotationMatcher lombokLogAnnotationMatcher = new AnnotationMatcher("@lombok.extern..*");
        return Preconditions.check((TreeVisitor)new UsesMethod(systemErrPrint), (TreeVisitor)Repeat.repeatUntilStable((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b = super.visitBlock(block, (Object)ctx);
                Cursor blockCursor = new Cursor(this.getCursor().getParent(), (Object)b);
                AtomicBoolean addedLogger = new AtomicBoolean(false);
                b = b.withStatements(this.collapseNextThrowablePrintStackTrace(b.getStatements(), ctx, blockCursor, addedLogger));
                return addedLogger.get() ? block : b;
            }

            public J.Case visitCase(J.Case _case, ExecutionContext ctx) {
                J.Case c = super.visitCase(_case, (Object)ctx);
                Cursor caseCursor = new Cursor(this.getCursor().getParent(), (Object)c);
                AtomicBoolean addedLogger = new AtomicBoolean(false);
                c = c.withStatements(this.collapseNextThrowablePrintStackTrace(c.getStatements(), ctx, caseCursor, addedLogger));
                return addedLogger.get() ? _case : c;
            }

            private List<Statement> collapseNextThrowablePrintStackTrace(List<Statement> statements, ExecutionContext ctx, Cursor cursor, AtomicBoolean addedLogger) {
                AtomicInteger skip = new AtomicInteger(-1);
                return ListUtils.map(statements, (i, stat) -> {
                    if (skip.get() == i.intValue()) {
                        return null;
                    }
                    if (stat instanceof J.MethodInvocation) {
                        JavaType.Variable field;
                        J.MethodInvocation m = (J.MethodInvocation)stat;
                        if (systemErrPrint.matches((Expression)stat) && m.getSelect() != null && m.getSelect() instanceof J.FieldAccess && (field = ((J.FieldAccess)m.getSelect()).getName().getFieldType()) != null && "err".equals(field.getName()) && TypeUtils.isOfClassType((JavaType)field.getOwner(), (String)"java.lang.System")) {
                            Cursor printCursor;
                            J.MethodInvocation unchangedIfAddedLogger;
                            J next;
                            Expression exceptionPrintStackTrace = null;
                            if (statements.size() > i + 1 && (next = (J)statements.get(i + 1)) instanceof J.MethodInvocation && printStackTrace.matches((Expression)next)) {
                                exceptionPrintStackTrace = ((J.MethodInvocation)next).getSelect();
                                skip.set(i + 1);
                            }
                            addedLogger.set((unchangedIfAddedLogger = this.logInsteadOfPrint(printCursor = new Cursor(cursor, (Object)m), ctx, exceptionPrintStackTrace)) == m);
                            return unchangedIfAddedLogger;
                        }
                    }
                    return stat;
                });
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                JavaType.Variable field;
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (systemErrPrint.matches((Expression)method) && this.getCursor().getParentOrThrow().getValue() instanceof J.Lambda && m.getSelect() != null && m.getSelect() instanceof J.FieldAccess && (field = ((J.FieldAccess)m.getSelect()).getName().getFieldType()) != null && "err".equals(field.getName()) && TypeUtils.isOfClassType((JavaType)field.getOwner(), (String)"java.lang.System")) {
                    Cursor printCursor = new Cursor(this.getCursor().getParent(), (Object)m);
                    return this.logInsteadOfPrint(printCursor, ctx, null);
                }
                return m;
            }

            private J.MethodInvocation logInsteadOfPrint(Cursor printCursor, ExecutionContext ctx, @Nullable Expression exceptionPrintStackTrace) {
                J.MethodInvocation print = (J.MethodInvocation)printCursor.getValue();
                Cursor classCursor = this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance);
                AnnotationService annotationService = (AnnotationService)this.service(AnnotationService.class);
                Set loggers = FindFieldsOfType.find((J)((J)classCursor.getValue()), (String)framework.getLoggerType());
                if (!loggers.isEmpty()) {
                    J.Identifier computedLoggerName = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)loggers.iterator().next()).getVariables().get(0)).getName();
                    print = this.replaceMethodInvocation(printCursor, ctx, exceptionPrintStackTrace, print, computedLoggerName);
                } else if (annotationService.matches(classCursor, lombokLogAnnotationMatcher)) {
                    String fieldName = SystemErrToLogging.this.loggerName == null ? "log" : SystemErrToLogging.this.loggerName;
                    J.Identifier logField = new J.Identifier(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, Collections.emptyList(), fieldName, null, null);
                    print = this.replaceMethodInvocation(printCursor, ctx, exceptionPrintStackTrace, print, logField);
                } else if (SystemErrToLogging.this.addLogger != null && SystemErrToLogging.this.addLogger.booleanValue()) {
                    this.doAfterVisit(AddLogger.addLogger((J.ClassDeclaration)classCursor.getValue(), framework, SystemErrToLogging.this.loggerName == null ? "logger" : SystemErrToLogging.this.loggerName, ctx));
                }
                return print;
            }

            private J.MethodInvocation replaceMethodInvocation(Cursor printCursor, ExecutionContext ctx, @Nullable Expression exceptionPrintStackTrace, J.MethodInvocation print, J.Identifier computedLoggerName) {
                print = exceptionPrintStackTrace == null ? (J.MethodInvocation)this.getErrorTemplateNoException(ctx).apply(printCursor, print.getCoordinates().replace(), new Object[]{computedLoggerName, print.getArguments().get(0)}) : (J.MethodInvocation)framework.getErrorTemplate("#{any(String)}", ctx).apply(printCursor, print.getCoordinates().replace(), new Object[]{computedLoggerName, print.getArguments().get(0), exceptionPrintStackTrace});
                if (framework == LoggingFramework.JUL) {
                    this.maybeAddImport("java.util.logging.Level");
                }
                return (J.MethodInvocation)new ParameterizedLogging(framework.getLoggerType() + " error(..)", false).getVisitor().visitNonNull((Tree)print, (Object)ctx, printCursor);
            }

            public JavaTemplate getErrorTemplateNoException(ExecutionContext ctx) {
                switch (framework) {
                    case SLF4J: {
                        return JavaTemplate.builder((String)"#{any(org.slf4j.Logger)}.error(#{any(String)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"slf4j-api-2.1"})).build();
                    }
                    case Log4J1: {
                        return JavaTemplate.builder((String)"#{any(org.apache.log4j.Category)}.error(#{any(String)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"log4j-1.2"})).build();
                    }
                    case Log4J2: {
                        return JavaTemplate.builder((String)"#{any(org.apache.logging.log4j.Logger)}.error(#{any(String)});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"log4j-api-2.23"})).build();
                    }
                }
                return JavaTemplate.builder((String)"#{any(java.util.logging.Logger)}.log(Level.SEVERE, #{any(String)});").imports(new String[]{"java.util.logging.Level"}).build();
            }
        }));
    }

    @ConstructorProperties(value={"addLogger", "loggerName", "loggingFramework"})
    @Generated
    public SystemErrToLogging(@Nullable Boolean addLogger, @Nullable String loggerName, @Nullable String loggingFramework) {
        this.addLogger = addLogger;
        this.loggerName = loggerName;
        this.loggingFramework = loggingFramework;
    }

    @Generated
    public @Nullable Boolean getAddLogger() {
        return this.addLogger;
    }

    @Generated
    public @Nullable String getLoggerName() {
        return this.loggerName;
    }

    @Generated
    public @Nullable String getLoggingFramework() {
        return this.loggingFramework;
    }

    @NonNull
    @Generated
    public String toString() {
        return "SystemErrToLogging(addLogger=" + this.getAddLogger() + ", loggerName=" + this.getLoggerName() + ", loggingFramework=" + this.getLoggingFramework() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemErrToLogging)) {
            return false;
        }
        SystemErrToLogging other = (SystemErrToLogging)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addLogger = this.getAddLogger();
        Boolean other$addLogger = other.getAddLogger();
        if (this$addLogger == null ? other$addLogger != null : !((Object)this$addLogger).equals(other$addLogger)) {
            return false;
        }
        String this$loggerName = this.getLoggerName();
        String other$loggerName = other.getLoggerName();
        if (this$loggerName == null ? other$loggerName != null : !this$loggerName.equals(other$loggerName)) {
            return false;
        }
        String this$loggingFramework = this.getLoggingFramework();
        String other$loggingFramework = other.getLoggingFramework();
        return !(this$loggingFramework == null ? other$loggingFramework != null : !this$loggingFramework.equals(other$loggingFramework));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof SystemErrToLogging;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addLogger = this.getAddLogger();
        result = result * 59 + ($addLogger == null ? 43 : ((Object)$addLogger).hashCode());
        String $loggerName = this.getLoggerName();
        result = result * 59 + ($loggerName == null ? 43 : $loggerName.hashCode());
        String $loggingFramework = this.getLoggingFramework();
        result = result * 59 + ($loggingFramework == null ? 43 : $loggingFramework.hashCode());
        return result;
    }
}

