/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.liberty;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.JavaProject;

public class PersistenceXmlLocationRule
extends Recipe {
    public String getDisplayName() {
        return "Move persistence.xml file";
    }

    public String getDescription() {
        return "This recipes moves persistence.xml files into the root META-INF directory in source folder.";
    }

    public File getProjectDirectory(File sourceFile, String projectName) {
        File parent;
        for (parent = sourceFile.getParentFile(); parent != null && !parent.getName().equals(projectName); parent = parent.getParentFile()) {
        }
        return parent;
    }

    public List<File> getSrcDirectories(SourceFile sourceFile) {
        File[] subDirs;
        ArrayList<File> srcDirs = new ArrayList<File>();
        Path sourcePath = sourceFile.getSourcePath();
        String projectName = sourceFile.getMarkers().findFirst(JavaProject.class).map(JavaProject::getProjectName).orElse("");
        File projectDirctory = this.getProjectDirectory(new File(sourcePath.toAbsolutePath().toString()), projectName);
        if (projectDirctory != null && (subDirs = projectDirctory.listFiles(File::isDirectory)) != null) {
            for (File subDir : subDirs) {
                String dirName = subDir.getName().toLowerCase();
                if (!dirName.endsWith("src") && !dirName.equals("source")) continue;
                srcDirs.add(subDir);
            }
        }
        return srcDirs;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext executionContext) {
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    Path sourcePath = ((SourceFile)tree).getSourcePath();
                    if (sourcePath.getFileName().toString().equals("persistence.xml")) {
                        String projectName = sourceFile.getMarkers().findFirst(JavaProject.class).map(JavaProject::getProjectName).orElse("");
                        List<File> srcDirs = PersistenceXmlLocationRule.this.getSrcDirectories(sourceFile);
                        boolean isValidPath = false;
                        boolean correctFileExists = false;
                        Path correctPath = null;
                        if (!srcDirs.isEmpty()) {
                            for (File srcDir : srcDirs) {
                                correctPath = srcDir.toPath().resolve("META-INF").resolve("persistence.xml");
                                if (sourcePath.toAbsolutePath().equals(correctPath.toAbsolutePath())) {
                                    isValidPath = true;
                                    break;
                                }
                                if (!correctPath.toFile().exists()) continue;
                                correctFileExists = true;
                            }
                        } else if (!sourcePath.toAbsolutePath().endsWith("src" + File.separator + "META-INF" + File.separator + "persistence.xml")) {
                            File projectFile = PersistenceXmlLocationRule.this.getProjectDirectory(new File(sourcePath.toAbsolutePath().toString()), projectName);
                            correctPath = projectFile.toPath().resolve("src").resolve("META-INF").resolve("persistence.xml");
                            return ((SourceFile)tree).withSourcePath(correctPath);
                        }
                        if (!isValidPath && !correctFileExists && correctPath != null) {
                            return ((SourceFile)tree).withSourcePath(correctPath);
                        }
                        return sourceFile;
                    }
                }
                return super.visit(tree, (Object)executionContext);
            }
        };
    }
}

