/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.SourceFile;
import org.openrewrite.maven.tree.MavenResolutionResult;

class Jenkins {
    private static final Predicate<String> LTS_PATTERN = Pattern.compile("^\\d\\.(\\d+)\\.\\d$").asPredicate();
    private static final Predicate<String> LTS_BASELINE_PATTERN = Pattern.compile("^\\$\\{jenkins.baseline\\}.\\d$").asPredicate();

    Jenkins() {
    }

    public static @Nullable String isJenkinsPluginPom(SourceFile sourceFile) {
        return sourceFile.getMarkers().findFirst(MavenResolutionResult.class).map(mavenResolution -> mavenResolution.getPom().getManagedVersion("org.jenkins-ci.main", "jenkins-core", null, null)).orElse(null);
    }

    public static @NonNull String bomNameForJenkinsVersion(@NonNull String version) {
        if (LTS_PATTERN.test(version) || LTS_BASELINE_PATTERN.test(version)) {
            if (version.startsWith("${jenkins.baseline}")) {
                return "bom-${jenkins.baseline}.x";
            }
            int lastIndex = version.lastIndexOf(".");
            String prefix = version.substring(0, lastIndex);
            return "bom-" + prefix + ".x";
        }
        return "bom-weekly";
    }
}

