/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.controlflow;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.controlflow.ControlFlowDotFileGenerator;
import org.openrewrite.analysis.controlflow.ControlFlowVisualizationVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class ControlFlowVisualization
extends Recipe {
    @Option(displayName="Include dotfile", description="Also output with a Dotfile which can be then later visualized by Graphviz.")
    private final boolean includeDotfile;
    private final boolean darkMode;

    public String getDisplayName() {
        return "Control flow visualization";
    }

    public String getDescription() {
        return "Visualize the control flow of a Java program.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ControlFlowVisualizationVisitor(this.includeDotfile ? ControlFlowDotFileGenerator.create() : null, this.darkMode);
    }

    @Generated
    public ControlFlowVisualization(boolean includeDotfile, boolean darkMode) {
        this.includeDotfile = includeDotfile;
        this.darkMode = darkMode;
    }

    @Generated
    public boolean isIncludeDotfile() {
        return this.includeDotfile;
    }

    @Generated
    public boolean isDarkMode() {
        return this.darkMode;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ControlFlowVisualization(includeDotfile=" + this.isIncludeDotfile() + ", darkMode=" + this.isDarkMode() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ControlFlowVisualization)) {
            return false;
        }
        ControlFlowVisualization other = (ControlFlowVisualization)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isIncludeDotfile() != other.isIncludeDotfile()) {
            return false;
        }
        return this.isDarkMode() == other.isDarkMode();
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ControlFlowVisualization;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeDotfile() ? 79 : 97);
        result = result * 59 + (this.isDarkMode() ? 79 : 97);
        return result;
    }
}

