/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.io;

import info.aduna.io.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtil {
    private static final byte[] MAGIC_NUMBER = new byte[]{80, 75, 3, 4};

    public static boolean isZipStream(InputStream in) throws IOException {
        in.mark(MAGIC_NUMBER.length);
        byte[] fileHeader = IOUtil.readBytes(in, MAGIC_NUMBER.length);
        in.reset();
        return Arrays.equals(MAGIC_NUMBER, fileHeader);
    }

    public static void extract(File zipFile, File destDir) throws IOException {
        try (ZipFile zf = new ZipFile(zipFile);){
            ZipUtil.extract(zf, destDir);
        }
    }

    public static void extract(ZipFile zipFile, File destDir) throws IOException {
        assert (destDir.isDirectory());
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            ZipUtil.writeEntry(zipFile, entry, destDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeEntry(ZipFile zipFile, ZipEntry entry, File destDir) throws IOException {
        File outFile = new File(destDir, entry.getName());
        if (entry.isDirectory()) {
            outFile.mkdirs();
        } else {
            outFile.getParentFile().mkdirs();
            try (InputStream in = zipFile.getInputStream(entry);){
                IOUtil.writeStream(in, outFile);
            }
        }
    }
}

