/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.demos.campusview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openimaj.demos.campusview.CaptureControlsDelegate;

public class CaptureControls
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField capHeightField;
    private JTextField capWidthField;
    private JTextField capRateTextField;
    private JTextField batchID;
    private JTextField operator;
    private CaptureControlsDelegate delegate;
    private JLabel metaFile;
    private JLabel imageDir;
    private JButton stopBatch;
    private JButton startBatch;

    public CaptureControls() {
        this.setLayout(new GridBagLayout());
        final JPanel batchControls = new JPanel(new GridBagLayout());
        batchControls.setBorder(BorderFactory.createTitledBorder("Batch Controls"));
        final JPanel captureControls = new JPanel(new GridBagLayout());
        captureControls.setBorder(BorderFactory.createTitledBorder("Capture Controls"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel batchIdL = new JLabel("Batch Identifier: ");
        gbc.insets = new Insets(0, 0, 5, 5);
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = 0;
        batchControls.add((Component)batchIdL, gbc);
        this.batchID = new JTextField("1");
        ++gbc.gridx;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        batchControls.add((Component)this.batchID, gbc);
        JLabel operatorLabel = new JLabel("Operator: ");
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        ++gbc.gridy;
        batchControls.add((Component)operatorLabel, gbc);
        this.operator = new JTextField("Jon");
        gbc.fill = 2;
        gbc.anchor = 11;
        ++gbc.gridx;
        gbc.weightx = 1.0;
        batchControls.add((Component)this.operator, gbc);
        JLabel lblCaptureWidth = new JLabel("Capture Width:");
        lblCaptureWidth.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblCaptureWidth = new GridBagConstraints();
        gbc_lblCaptureWidth.anchor = 13;
        gbc_lblCaptureWidth.insets = new Insets(0, 0, 5, 5);
        gbc_lblCaptureWidth.gridx = 0;
        gbc_lblCaptureWidth.gridy = 10;
        batchControls.add((Component)lblCaptureWidth, gbc_lblCaptureWidth);
        this.capWidthField = new JTextField();
        this.capWidthField.setColumns(10);
        GridBagConstraints gbc_capWidthField = new GridBagConstraints();
        gbc_capWidthField.fill = 2;
        gbc_capWidthField.anchor = 11;
        gbc_capWidthField.insets = new Insets(0, 0, 5, 5);
        gbc_capWidthField.gridx = 1;
        gbc_capWidthField.gridy = 10;
        gbc_capWidthField.weightx = 1.0;
        batchControls.add((Component)this.capWidthField, gbc_capWidthField);
        JLabel lblNewLabel = new JLabel("Capture Height:");
        lblNewLabel.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 13;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 20;
        batchControls.add((Component)lblNewLabel, gbc_lblNewLabel);
        this.capHeightField = new JTextField();
        GridBagConstraints gbc_capHeightField = new GridBagConstraints();
        gbc_capHeightField.anchor = 11;
        gbc_capHeightField.fill = 2;
        gbc_capHeightField.insets = new Insets(0, 0, 5, 5);
        gbc_capHeightField.gridx = 1;
        gbc_capHeightField.gridy = 20;
        gbc_capHeightField.weightx = 1.0;
        batchControls.add((Component)this.capHeightField, gbc_capHeightField);
        this.capHeightField.setColumns(10);
        JLabel lblCaptureRate = new JLabel("Capture Rate (secs):");
        lblCaptureRate.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblCaptureRate = new GridBagConstraints();
        gbc_lblCaptureRate.anchor = 13;
        gbc_lblCaptureRate.insets = new Insets(0, 0, 5, 5);
        gbc_lblCaptureRate.gridx = 0;
        gbc_lblCaptureRate.gridy = 30;
        gbc_lblCaptureRate.weightx = 1.0;
        batchControls.add((Component)lblCaptureRate, gbc_lblCaptureRate);
        this.capRateTextField = new JTextField("5");
        this.capRateTextField.setColumns(10);
        GridBagConstraints gbc_textField = new GridBagConstraints();
        gbc_textField.anchor = 11;
        gbc_textField.fill = 2;
        gbc_textField.insets = new Insets(0, 0, 5, 5);
        gbc_textField.gridx = 1;
        gbc_textField.gridy = 30;
        batchControls.add((Component)this.capRateTextField, gbc_textField);
        JLabel lblImageDirectory = new JLabel("Image Directory:");
        lblImageDirectory.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblImageDirectory = new GridBagConstraints();
        gbc_lblImageDirectory.fill = 2;
        gbc_lblImageDirectory.insets = new Insets(0, 0, 5, 5);
        gbc_lblImageDirectory.gridx = 0;
        gbc_lblImageDirectory.gridy = 40;
        batchControls.add((Component)lblImageDirectory, gbc_lblImageDirectory);
        this.imageDir = new JLabel(System.getProperty("user.home") + "/campusview/images");
        GridBagConstraints gbc_imageDir = new GridBagConstraints();
        gbc_imageDir.gridwidth = 2;
        gbc_imageDir.fill = 2;
        gbc_imageDir.insets = new Insets(0, 0, 5, 5);
        gbc_imageDir.gridx = 1;
        gbc_imageDir.gridy = 40;
        batchControls.add((Component)this.imageDir, gbc_imageDir);
        JButton btnSetDir = new JButton("Set");
        GridBagConstraints gbc_btnSetDir = new GridBagConstraints();
        gbc_btnSetDir.anchor = 17;
        gbc_btnSetDir.insets = new Insets(0, 0, 5, 0);
        gbc_btnSetDir.gridx = 3;
        gbc_btnSetDir.gridy = 40;
        batchControls.add((Component)btnSetDir, gbc_btnSetDir);
        btnSetDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(new File(CaptureControls.this.imageDir.getText()));
                chooser.setFileSelectionMode(1);
                chooser.setAcceptAllFileFilterUsed(false);
                if (chooser.showSaveDialog(CaptureControls.this) == 0) {
                    CaptureControls.this.imageDir.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        JButton btnSnapshot = new JButton("Snapshot");
        GridBagConstraints gbc_btnSnapshot = new GridBagConstraints();
        gbc_btnSnapshot.anchor = 15;
        gbc_btnSnapshot.fill = 2;
        gbc_btnSnapshot.insets = new Insets(0, 0, 0, 5);
        gbc_btnSnapshot.gridx = 0;
        gbc_btnSnapshot.gridy = 6;
        btnSnapshot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaptureControls.this.delegate.snapshot();
            }
        });
        captureControls.add((Component)btnSnapshot, gbc_btnSnapshot);
        btnSnapshot.setEnabled(false);
        final JButton btnStartRecording = new JButton("Start Recording");
        final JButton btnStopRecording = new JButton("Stop Recording");
        GridBagConstraints gbc_btnStartRecording = new GridBagConstraints();
        gbc_btnStartRecording.gridwidth = 1;
        gbc_btnStartRecording.anchor = 16;
        gbc_btnStartRecording.insets = new Insets(0, 0, 0, 5);
        gbc_btnStartRecording.gridx = 1;
        gbc_btnStartRecording.gridy = 6;
        captureControls.add((Component)btnStartRecording, gbc_btnStartRecording);
        btnStartRecording.setEnabled(false);
        btnStartRecording.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaptureControls.this.delegate.startRecording(CaptureControls.this.getRate());
                btnStopRecording.setEnabled(true);
                btnStartRecording.setEnabled(false);
                CaptureControls.this.stopBatch.setEnabled(false);
            }
        });
        GridBagConstraints gbc_btnStopRecording = new GridBagConstraints();
        gbc_btnStopRecording.gridwidth = 1;
        gbc_btnStopRecording.anchor = 16;
        gbc_btnStopRecording.insets = new Insets(0, 0, 0, 5);
        gbc_btnStopRecording.gridx = 2;
        gbc_btnStopRecording.gridy = 6;
        captureControls.add((Component)btnStopRecording, gbc_btnStopRecording);
        btnStopRecording.setEnabled(false);
        btnStopRecording.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaptureControls.this.delegate.stopRecording();
                btnStartRecording.setEnabled(true);
                CaptureControls.this.stopBatch.setEnabled(true);
                btnStopRecording.setEnabled(false);
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 100;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.startBatch = new JButton("Start Batch");
        this.stopBatch = new JButton("Stop Batch");
        this.startBatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                for (i = 0; i < captureControls.getComponentCount(); ++i) {
                    captureControls.getComponent(i).setEnabled(true);
                }
                for (i = 0; i < batchControls.getComponentCount(); ++i) {
                    batchControls.getComponent(i).setEnabled(false);
                }
                CaptureControls.this.stopBatch.setEnabled(true);
                CaptureControls.this.startBatch.setEnabled(false);
                btnStopRecording.setEnabled(false);
                CaptureControls.this.delegate.startBatch(CaptureControls.this.getImageDir(), null, CaptureControls.this.getOperator(), "Private");
            }
        });
        buttonPanel.add((Component)this.startBatch, gbc);
        this.stopBatch.setEnabled(false);
        this.stopBatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                for (i = 0; i < captureControls.getComponentCount(); ++i) {
                    captureControls.getComponent(i).setEnabled(false);
                }
                for (i = 0; i < batchControls.getComponentCount(); ++i) {
                    batchControls.getComponent(i).setEnabled(true);
                }
                CaptureControls.this.stopBatch.setEnabled(false);
                CaptureControls.this.startBatch.setEnabled(true);
                CaptureControls.this.batchID.setText("" + (CaptureControls.this.getBatchId() + 1));
                CaptureControls.this.delegate.stopBatch();
            }
        });
        ++gbc.gridx;
        buttonPanel.add((Component)this.stopBatch, gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        batchControls.add((Component)buttonPanel, gbc);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)batchControls, gbc);
        ++gbc.gridy;
        this.add((Component)captureControls, gbc);
    }

    protected File getImageDir() {
        return new File(this.imageDir.getText());
    }

    protected File getMetadataFile() {
        return new File(this.metaFile.getText());
    }

    public void setDelegate(CaptureControlsDelegate delegate) {
        this.delegate = delegate;
    }

    public int getBatchId() {
        return Integer.parseInt(this.batchID.getText());
    }

    public String getOperator() {
        return this.operator.getText();
    }

    public int getRate() {
        return Integer.parseInt(this.capRateTextField.getText());
    }
}

