/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.demos.campusview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openimaj.image.MBFImage;
import org.openimaj.video.Video;
import org.openimaj.video.VideoDisplay;
import org.openimaj.video.capture.Device;
import org.openimaj.video.capture.VideoCapture;
import org.openimaj.video.capture.VideoCaptureException;

public class CaptureComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final List<Device> devices = VideoCapture.getVideoDevices();
    private JComboBox comboBox;
    private JPanel panel;
    private JLabel label;
    private VideoDisplay<MBFImage> display;
    private int capHeight = 320;
    private int capWidth = 240;
    private double capRate = 25.0;
    private int defaultWidth = 320;
    private int defaultHeight = 240;

    public CaptureComponent() {
        this(640, 480, 1.0);
    }

    public CaptureComponent(int capWidth, int capHeight, double capRate) {
        this.capWidth = capWidth;
        this.capHeight = capHeight;
        this.capRate = capRate;
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.label = new JLabel("Camera #1");
        this.label.setForeground(Color.WHITE);
        this.label.setFont(new Font("Lucida Grande", 0, 16));
        this.label.setBounds(6, 6, 124, 16);
        this.add((Component)this.label, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.comboBox = new JComboBox();
        this.comboBox.setBounds(6, 286, 320, 27);
        this.add((Component)this.comboBox, gbc);
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.panel.setBounds(6, 34, this.defaultWidth, this.defaultHeight);
        this.panel.setMaximumSize(new Dimension(this.defaultWidth, this.defaultHeight));
        this.add((Component)this.panel, gbc);
        this.initSrcList();
    }

    public void setTitle(String title) {
        this.label.setText(title);
    }

    public String getTitle() {
        return this.label.getText();
    }

    private void initSrcList() {
        this.comboBox.addItem("None");
        for (Device d : devices) {
            this.comboBox.addItem(d);
        }
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaptureComponent.this.setupVideo();
            }
        });
        this.comboBox.setSelectedItem(0);
    }

    private void setupVideo() {
        if (this.comboBox.getSelectedItem().equals("None")) {
            return;
        }
        Device dev = (Device)this.comboBox.getSelectedItem();
        if (this.display != null) {
            ((VideoCapture)this.display.getVideo()).stopCapture();
            this.panel.removeAll();
        }
        System.out.println(dev);
        try {
            this.display = VideoDisplay.createVideoDisplay((Video)new VideoCapture(this.capWidth, this.capHeight, this.capRate, dev), (JComponent)this.panel);
        }
        catch (VideoCaptureException e) {
            throw new RuntimeException(e);
        }
        this.revalidate();
        this.repaint();
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public void setCapHeight(int capHeight) {
        this.capHeight = capHeight;
        this.setupVideo();
    }

    public int getCapWidth() {
        return this.capWidth;
    }

    public void setCapWidth(int capWidth) {
        this.capWidth = capWidth;
        this.setupVideo();
    }

    public double getCapRate() {
        return this.capRate;
    }

    @Override
    public int getWidth() {
        if (this.display != null) {
            return this.display.getScreen().getWidth();
        }
        return this.defaultWidth;
    }

    @Override
    public int getHeight() {
        if (this.display != null) {
            return this.display.getScreen().getHeight();
        }
        return this.defaultHeight;
    }

    public void setCapRate(double capRate) {
        this.capRate = capRate;
        this.setupVideo();
    }

    public MBFImage getCurrentFrame() {
        if (this.display != null) {
            return (MBFImage)this.display.getVideo().getCurrentFrame();
        }
        return null;
    }
}

