/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.demos.campusview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.joda.time.DateTime;
import org.openimaj.demos.campusview.CSVWriter;
import org.openimaj.demos.campusview.CaptureComponent;
import org.openimaj.demos.campusview.CaptureControls;
import org.openimaj.demos.campusview.CaptureControlsDelegate;
import org.openimaj.demos.campusview.CompassComponent;
import org.openimaj.demos.campusview.GPSPositionComponent;
import org.openimaj.hardware.compass.CompassData;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;

public class CampusView
implements CaptureControlsDelegate {
    private JFrame frame;
    private List<CaptureComponent> captureComponents = new ArrayList<CaptureComponent>();
    private int captureCount = 0;
    private CaptureControls captureControls;
    private GPSPositionComponent gpsComp;
    private CompassComponent compassComp;
    private JPanel contentPanel;
    private double captureRate = 5.0;
    private boolean runCapture = false;
    private File imageDir;
    private File imageMetadata;
    private File batchMetadata;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    CampusView window = new CampusView();
                    window.frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public CampusView() throws IOException {
        this.initialize();
    }

    private void initialize() throws IOException {
        this.contentPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
            }
        };
        this.contentPanel.setLayout(null);
        this.frame = new JFrame();
        this.frame.getContentPane().setBackground(Color.black);
        this.frame.setBounds(0, 0, 1680, 1050);
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add(this.contentPanel);
        int numCameras = 6;
        int rowSize = 3;
        int x = 0;
        int y = 50;
        int maxX = 0;
        for (int i = 0; i < numCameras; ++i) {
            CaptureComponent captureComponent = new CaptureComponent();
            captureComponent.setTitle("Camera #" + (i + 1));
            captureComponent.setBounds(x, y, captureComponent.getWidth(), captureComponent.getHeight());
            this.contentPanel.add(captureComponent);
            this.captureComponents.add(captureComponent);
            if (i % rowSize == rowSize - 1) {
                y += captureComponent.getHeight() + 40;
                x = 0;
            } else {
                x += captureComponent.getWidth() + 30;
            }
            maxX = Math.max(x + captureComponent.getWidth() + 30, maxX);
        }
        this.captureControls = new CaptureControls();
        this.captureControls.setBounds(maxX + 50, 50, 563, 350);
        this.captureControls.setDelegate(this);
        this.contentPanel.add(this.captureControls);
        this.gpsComp = new GPSPositionComponent();
        this.gpsComp.setBackground(new Color(255, 255, 255, 210));
        this.gpsComp.setBounds(maxX + 50, this.captureControls.getBounds().y + this.captureControls.getBounds().height + 10, 563, 50);
        this.contentPanel.add(this.gpsComp);
        this.compassComp = new CompassComponent();
        this.compassComp.setBackground(new Color(255, 255, 255, 210));
        this.compassComp.setBounds(maxX + 50, this.gpsComp.getBounds().y + this.gpsComp.getBounds().height + 10, 563, 50);
        this.contentPanel.add(this.compassComp);
    }

    @Override
    public void snapshot() {
        MBFImage[] images = new MBFImage[this.captureComponents.size()];
        for (CaptureComponent cc : this.captureComponents) {
            int id = Integer.parseInt(cc.getTitle().substring(cc.getTitle().indexOf("#") + 1)) - 1;
            MBFImage f = cc.getCurrentFrame();
            if (f == null) continue;
            images[id] = (MBFImage)f.clone();
        }
        for (int i = 0; i < images.length; ++i) {
            try {
                if (images[i] == null) continue;
                System.out.println("Writing image " + this.captureCount + "-" + i);
                File captureDir = new File(this.imageDir, "" + this.captureCount);
                captureDir.mkdirs();
                ImageUtilities.write((Image)images[i], (File)new File(captureDir, i + ".png"));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<String> dataList = new ArrayList<String>();
        dataList.add("" + this.captureCount);
        dataList.add("" + this.gpsComp.getGPS().getLatitude());
        dataList.add("" + this.gpsComp.getGPS().getLongitude());
        dataList.add("" + new DateTime());
        CompassData c = this.compassComp.getCompass().getCompassData();
        if (c != null) {
            dataList.add("" + c.compass);
            dataList.add("" + c.pitch);
            dataList.add("" + c.roll);
            dataList.add("" + c.ax);
            dataList.add("" + c.ay);
            dataList.add("" + c.az);
        } else {
            dataList.add("");
            dataList.add("");
            dataList.add("");
            dataList.add("");
            dataList.add("");
            dataList.add("");
        }
        dataList.add("Notes");
        System.out.println("Writing CSV File: " + this.imageMetadata);
        CSVWriter.writeLine(this.imageMetadata, dataList.toArray(new String[0]));
        ++this.captureCount;
    }

    @Override
    public void startRecording(int rateSeconds) {
        this.runCapture = true;
        new Thread(new Runnable(){

            @Override
            public synchronized void run() {
                while (CampusView.this.runCapture) {
                    try {
                        CampusView.this.snapshot();
                        this.wait((int)CampusView.this.captureRate * 1000);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    @Override
    public void stopRecording() {
        this.runCapture = false;
    }

    @Override
    public void updateCaptureSettings(int capWidth, int capHeight, double capRate) {
        this.captureRate = capRate;
    }

    @Override
    public void startBatch(File dir, File md, String capturer, String type) {
        dir.mkdirs();
        this.imageDir = new File(dir + File.separator + this.captureControls.getBatchId());
        this.imageDir.mkdirs();
        this.imageMetadata = new File(this.imageDir + File.separator + "metadata.csv");
        this.batchMetadata = new File(dir + File.separator + "batchMetadata.csv");
        ArrayList<String> batchData = new ArrayList<String>();
        batchData.add("" + this.captureControls.getBatchId());
        batchData.add(capturer);
        batchData.add(type);
        CSVWriter.writeLine(this.batchMetadata, batchData.toArray(new String[0]));
    }

    @Override
    public void stopBatch() {
        this.captureCount = 0;
    }
}

