/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.quickautobalance;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opengauss.jdbc.PgConnection;
import org.opengauss.log.Log;
import org.opengauss.log.Logger;
import org.opengauss.quickautobalance.ConnectionManager;
import org.opengauss.util.GT;
import org.opengauss.util.PSQLException;

public class LoadBalanceHeartBeating {
    private static final int INITIAL_DELAY = 1000;
    private static final int CHECK_CLUSTER_STATE_PERIOD = 20000;
    private static final int CLOSE_CONNECTION_PERIOD = 5000;
    private static ScheduledExecutorService checkClusterStateScheduledExecutorService = null;
    private static ScheduledExecutorService closeConnectionExecutorService = null;
    private static Log LOGGER = Logger.getLogger(LoadBalanceHeartBeating.class.getName());
    private static final AtomicInteger emptyCacheTime = new AtomicInteger(0);
    private static final ReentrantReadWriteLock reentrantLock = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock readLock = reentrantLock.readLock();
    private static final ReentrantReadWriteLock.WriteLock writeLock = reentrantLock.writeLock();
    private static volatile boolean leastConnStarted = false;
    private static volatile boolean quickAutoBalanceStarted = false;

    public static boolean isLoadBalanceHeartBeatingStarted() {
        return leastConnStarted && quickAutoBalanceStarted;
    }

    public static boolean isQuickAutoBalanceStarted() {
        return quickAutoBalanceStarted;
    }

    public static boolean isLeastConnStarted() {
        return leastConnStarted;
    }

    public static void setConnection(PgConnection pgConnection, Properties props) throws PSQLException {
        if (!ConnectionManager.checkEnableLeastConn(props)) {
            return;
        }
        try {
            readLock.lock();
            if (ConnectionManager.getInstance().setConnection(pgConnection, props)) {
                LoadBalanceHeartBeating.startScheduledExecutorService(props);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startScheduledExecutorService(Properties properties) {
        if (leastConnStarted && quickAutoBalanceStarted) {
            return;
        }
        if (!ConnectionManager.checkEnableLeastConn(properties)) {
            return;
        }
        if (leastConnStarted && !ConnectionManager.checkEnableQuickAutoBalance(properties)) {
            return;
        }
        Class<LoadBalanceHeartBeating> clazz = LoadBalanceHeartBeating.class;
        synchronized (LoadBalanceHeartBeating.class) {
            if (!leastConnStarted && ConnectionManager.checkEnableLeastConn(properties)) {
                leastConnStarted = true;
                checkClusterStateScheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "checkClusterStateHeartBeatingThread"));
                checkClusterStateScheduledExecutorService.scheduleAtFixedRate(LoadBalanceHeartBeating::checkClusterStateScheduleTask, 1000L, 20000L, TimeUnit.MILLISECONDS);
                LOGGER.info(GT.tr("Start scheduleExecutorService, period:{0} milliseconds.", 20000));
            }
            if (!quickAutoBalanceStarted && ConnectionManager.checkEnableQuickAutoBalance(properties)) {
                quickAutoBalanceStarted = true;
                closeConnectionExecutorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "closeConnectionsHeartBeatingThread"));
                closeConnectionExecutorService.scheduleAtFixedRate(LoadBalanceHeartBeating::closeAbandonedConnections, 1000L, 5000L, TimeUnit.MILLISECONDS);
                LOGGER.info(GT.tr("Start closeConnectionScheduledFuture, period:{0} milliseconds.", 5000));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void checkClusterStateScheduleTask() {
        LoadBalanceHeartBeating.checkClusterState();
        LoadBalanceHeartBeating.checkConnectionValidity();
        LoadBalanceHeartBeating.checkHeartBeatingThreadShouldStop();
    }

    private static void closeAbandonedConnections() {
        List<Integer> closedConnections = ConnectionManager.getInstance().closeConnections();
        int sum = closedConnections.stream().mapToInt(Integer::intValue).sum();
        LOGGER.info(GT.tr("Scheduled task: closeAbandonedConnections(), thread id: {0}, amount of closed connections: {1}.", Thread.currentThread().getId(), sum));
    }

    private static void checkClusterState() {
        int invalidDataNodes = ConnectionManager.getInstance().checkClusterStates();
        LOGGER.info(GT.tr("Scheduled task: checkClusterState(), thread id: {0}, amount of invalid data nodes: {1}.", Thread.currentThread().getId(), invalidDataNodes));
    }

    private static void checkConnectionValidity() {
        List<Integer> removes = ConnectionManager.getInstance().checkConnectionsValidity();
        int sum = removes.stream().mapToInt(Integer::intValue).sum();
        LOGGER.info(GT.tr("Scheduled task: checkConnectionValidity(), thread id: {0}, amount of removed connections: {1}.", Thread.currentThread().getId(), sum));
    }

    private static void checkHeartBeatingThreadShouldStop() {
        int maxCachedConnectionsEmptyTimesBeforeClear = 2;
        int cachedConnectionSize = ConnectionManager.getInstance().getCachedConnectionSize();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(GT.tr("CachedConnectionSize = {0}.", cachedConnectionSize));
        }
        if (cachedConnectionSize != 0) {
            emptyCacheTime.set(0);
            return;
        }
        emptyCacheTime.incrementAndGet();
        if (emptyCacheTime.get() >= maxCachedConnectionsEmptyTimesBeforeClear) {
            try {
                writeLock.lock();
                if (ConnectionManager.getInstance().getCachedConnectionSize() == 0) {
                    emptyCacheTime.set(0);
                    LoadBalanceHeartBeating.stopHeartBeatingThread();
                }
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopHeartBeatingThread() {
        if (!leastConnStarted && !quickAutoBalanceStarted) {
            return;
        }
        Class<LoadBalanceHeartBeating> clazz = LoadBalanceHeartBeating.class;
        synchronized (LoadBalanceHeartBeating.class) {
            if (leastConnStarted) {
                checkClusterStateScheduledExecutorService.shutdownNow();
                checkClusterStateScheduledExecutorService = null;
                leastConnStarted = false;
                LOGGER.info(GT.tr("ScheduledExecutorService: {0} close.", "loadBalanceHeartBeatingThread"));
            }
            if (quickAutoBalanceStarted) {
                closeConnectionExecutorService.shutdownNow();
                closeConnectionExecutorService = null;
                quickAutoBalanceStarted = false;
                LOGGER.info(GT.tr("ScheduledExecutorService: {0} close.", "closeConnectionsHeartBeatingThread"));
            }
            ConnectionManager.getInstance().clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

