/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.gss;

import java.io.IOException;
import java.security.AccessController;
import java.sql.SQLException;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSCredential;
import org.postgresql.core.PGStream;
import org.postgresql.gss.GSSCallbackHandler;
import org.postgresql.gss.GssAction;
import org.postgresql.log.Log;
import org.postgresql.log.Logger;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class MakeGSS {
    private static Log LOGGER = Logger.getLogger(MakeGSS.class.getName());

    public static void authenticate(PGStream pgStream, String host, String user, String password, String jaasApplicationName, String kerberosServerName, boolean useSpnego, boolean jaasLogin) throws IOException, SQLException {
        Exception result;
        LOGGER.trace(" <=BE AuthenticationReqGSS");
        if (jaasApplicationName == null) {
            jaasApplicationName = "pgjdbc";
        }
        if (kerberosServerName == null) {
            kerberosServerName = "postgres";
        }
        try {
            Set<GSSCredential> gssCreds;
            boolean performAuthentication = jaasLogin;
            GSSCredential gssCredential = null;
            Subject sub = Subject.getSubject(AccessController.getContext());
            if (sub != null && (gssCreds = sub.getPrivateCredentials(GSSCredential.class)) != null && !gssCreds.isEmpty()) {
                gssCredential = gssCreds.iterator().next();
                performAuthentication = false;
            }
            if (performAuthentication) {
                LoginContext lc = new LoginContext(jaasApplicationName, new GSSCallbackHandler(user, password));
                lc.login();
                sub = lc.getSubject();
            }
            GssAction action = new GssAction(pgStream, gssCredential, host, user, kerberosServerName, useSpnego);
            result = Subject.doAs(sub, action);
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        if (result instanceof SQLException) {
            throw (SQLException)result;
        }
        if (result != null) {
            throw new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)result);
        }
    }
}

