/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.terminology;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.terminology.CodeSystemInfo;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;

public class R4FhirTerminologyProvider
implements TerminologyProvider {
    private IGenericClient fhirClient;

    public R4FhirTerminologyProvider() {
    }

    public R4FhirTerminologyProvider(IGenericClient fhirClient) {
        this.fhirClient = fhirClient;
    }

    public IGenericClient getFhirClient() {
        return this.fhirClient;
    }

    public boolean in(Code code, ValueSetInfo valueSet) throws ResourceNotFoundException {
        if (this.resolveByUrl(valueSet) == null) {
            return false;
        }
        Parameters respParam = code.getSystem() != null ? (Parameters)((IOperationUnnamed)this.fhirClient.operation().onInstance((IIdType)new IdType("ValueSet", valueSet.getId()))).named("validate-code").withParameter(Parameters.class, "code", (IBase)new StringType(code.getCode())).andParameter("system", (IBase)new StringType(code.getSystem())).useHttpGet().execute() : (Parameters)((IOperationUnnamed)this.fhirClient.operation().onInstance((IIdType)new IdType("ValueSet", valueSet.getId()))).named("validate-code").withParameter(Parameters.class, "code", (IBase)new StringType(code.getCode())).useHttpGet().execute();
        return ((BooleanType)((Parameters.ParametersParameterComponent)respParam.getParameter().get(0)).getValue()).booleanValue();
    }

    public Iterable<Code> expand(ValueSetInfo valueSet) throws ResourceNotFoundException {
        if (this.resolveByUrl(valueSet) == null) {
            return Collections.emptyList();
        }
        Parameters respParam = (Parameters)((IOperationUnnamed)this.fhirClient.operation().onInstance((IIdType)new IdType("ValueSet", valueSet.getId()))).named("expand").withNoParameters(Parameters.class).execute();
        ValueSet expanded = (ValueSet)((Parameters.ParametersParameterComponent)respParam.getParameter().get(0)).getResource();
        ArrayList<Code> codes = new ArrayList<Code>();
        for (ValueSet.ValueSetExpansionContainsComponent codeInfo : expanded.getExpansion().getContains()) {
            Code nextCode = new Code().withCode(codeInfo.getCode()).withSystem(codeInfo.getSystem()).withVersion(codeInfo.getVersion()).withDisplay(codeInfo.getDisplay());
            codes.add(nextCode);
        }
        return codes;
    }

    public Code lookup(Code code, CodeSystemInfo codeSystem) throws ResourceNotFoundException {
        Parameters respParam = (Parameters)((IOperationUnnamed)this.fhirClient.operation().onType(CodeSystem.class)).named("lookup").withParameter(Parameters.class, "code", (IBase)new CodeType(code.getCode())).andParameter("system", (IBase)new UriType(codeSystem.getId())).execute();
        return code.withSystem(codeSystem.getId()).withDisplay((String)((StringType)((Parameters.ParametersParameterComponent)respParam.getParameter().get(1)).getValue()).getValue());
    }

    public Boolean resolveByUrl(ValueSetInfo valueSet) {
        block4: {
            try {
                URL url = new URL(valueSet.getId());
                Bundle searchResults = (Bundle)this.fhirClient.search().forResource(ValueSet.class).where(ValueSet.URL.matches().value(url.toString())).returnBundle(Bundle.class).execute();
                if (searchResults.hasEntry()) {
                    if (searchResults.getEntryFirstRep().hasResource()) {
                        valueSet.setId(searchResults.getEntryFirstRep().getResource().getIdElement().getIdPart());
                    }
                    break block4;
                }
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return true;
    }
}

