/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.AbstractJavaJAXRSServerCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.GzipTestFeatures;
import org.openapitools.codegen.languages.features.LoggingTestFeatures;
import org.openapitools.codegen.languages.features.UseGenericResponseFeatures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCXFClientCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
UseGenericResponseFeatures,
GzipTestFeatures,
LoggingTestFeatures {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaCXFClientCodegen.class);
    protected static final String JAXRS_TEMPLATE_DIRECTORY_NAME = "JavaJaxRS";
    protected boolean useBeanValidation = false;
    protected boolean useGenericResponse = false;
    protected boolean useGzipFeatureForTests = false;
    protected boolean useLoggingFeatureForTests = false;

    public JavaCXFClientCodegen() {
        this.supportsInheritance = true;
        this.sourceFolder = "src/gen/java";
        this.invokerPackage = "org.openapitools.api";
        this.artifactId = "openapi-jaxrs-client";
        this.dateLibrary = "legacy";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.outputFolder = "generated-code/JavaJaxRS-CXF";
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.typeMapping.put("date", "LocalDate");
        this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
        this.embeddedTemplateDir = this.templateDir = JAXRS_TEMPLATE_DIRECTORY_NAME + File.separator + "cxf";
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use BeanValidation API annotations"));
        this.cliOptions.add(CliOption.newBoolean("useGzipFeatureForTests", "Use Gzip Feature for tests"));
        this.cliOptions.add(CliOption.newBoolean("useLoggingFeatureForTests", "Use Logging Feature for tests"));
        this.cliOptions.add(CliOption.newBoolean("useGenericResponse", "Use generic response"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            boolean useBeanValidationProp = this.convertPropertyToBooleanAndWriteBack("useBeanValidation");
            this.setUseBeanValidation(useBeanValidationProp);
        }
        if (this.additionalProperties.containsKey("useGenericResponse")) {
            this.setUseGenericResponse(this.convertPropertyToBoolean("useGenericResponse"));
        }
        if (this.useGenericResponse) {
            this.writePropertyBack("useGenericResponse", this.useGenericResponse);
        }
        this.setUseGzipFeatureForTests(this.convertPropertyToBooleanAndWriteBack("useGzipFeatureForTests"));
        this.setUseLoggingFeatureForTests(this.convertPropertyToBooleanAndWriteBack("useLoggingFeatureForTests"));
        this.supportingFiles.clear();
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
    }

    @Override
    public String getName() {
        return "jaxrs-cxf-client";
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        super.addOperationToGroup(tag, resourcePath, operation, co, operations);
        co.subresourceOperation = !co.path.isEmpty();
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        model.imports.remove("ApiModelProperty");
        model.imports.remove("ApiModel");
        model.imports.remove("JsonSerialize");
        model.imports.remove("ToStringSerializer");
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        objs = super.postProcessOperations(objs);
        return AbstractJavaJAXRSServerCodegen.jaxrsPostProcessOperations(objs);
    }

    @Override
    public String getHelp() {
        return "Generates a Java JAXRS Client based on Apache CXF framework.";
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setUseGzipFeatureForTests(boolean useGzipFeatureForTests) {
        this.useGzipFeatureForTests = useGzipFeatureForTests;
    }

    @Override
    public void setUseLoggingFeatureForTests(boolean useLoggingFeatureForTests) {
        this.useLoggingFeatureForTests = useLoggingFeatureForTests;
    }

    @Override
    public void setUseGenericResponse(boolean useGenericResponse) {
        this.useGenericResponse = useGenericResponse;
    }
}

