/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.sign.stamppos;

import java.util.ArrayList;
import java.util.List;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.signatures.appearance.StampAnnot;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.sign.SignIDProvider;
import org.ofdrw.sign.stamppos.Side;
import org.ofdrw.sign.stamppos.StampAppearance;

public class RidingStampPos
implements StampAppearance {
    private Side side;
    private double width;
    private double height;
    private Double offset = null;
    private double margin = 0.0;
    private int clipNumber = 0;

    public RidingStampPos(double width, double height) {
        this.width = width;
        this.height = height;
        this.side = Side.Right;
    }

    public RidingStampPos(Side side, double width, double height) {
        this.side = side;
        this.width = width;
        this.height = height;
    }

    public RidingStampPos(Side side, Double offset, double width, double height) {
        this.side = side;
        this.width = width;
        this.height = height;
        this.offset = offset;
    }

    public RidingStampPos(Side side, Double offset, double width, double height, double margin) {
        this.side = side;
        this.width = width;
        this.height = height;
        this.offset = offset;
        this.margin = margin;
    }

    public RidingStampPos(Side side, Double offset, Integer clipNumber, double width, double height, double margin) {
        this.side = side;
        this.width = width;
        this.height = height;
        this.offset = offset;
        this.margin = margin;
        this.clipNumber = clipNumber;
    }

    public Side getSide() {
        return this.side;
    }

    public RidingStampPos setSide(Side side) {
        this.side = side;
        return this;
    }

    public double getWidth() {
        return this.width;
    }

    public RidingStampPos setWidth(double width) {
        this.width = width;
        return this;
    }

    public double getHeight() {
        return this.height;
    }

    public RidingStampPos setHeight(double height) {
        this.height = height;
        return this;
    }

    public Double getOffset() {
        return this.offset;
    }

    public RidingStampPos setOffset(Double offset) {
        this.offset = offset;
        return this;
    }

    public double getMargin() {
        return this.margin;
    }

    public RidingStampPos setMargin(double margin) {
        this.margin = margin;
        return this;
    }

    public int getClipNumber() {
        return this.clipNumber;
    }

    public RidingStampPos setClipNumber(int clipNumber) {
        this.clipNumber = clipNumber;
        return this;
    }

    @Override
    public List<StampAnnot> getAppearance(OFDReader ctx, SignIDProvider idProvider) {
        int numPage = ctx.getNumberOfPages();
        ArrayList<StampAnnot> res = new ArrayList<StampAnnot>(numPage);
        boolean isClipNumber = this.clipNumber > 0 && this.clipNumber < numPage;
        int leftClipNumber = 0;
        if (this.side == Side.Right || this.side == Side.Left) {
            double itemWith = this.width / (double)numPage;
            if (isClipNumber) {
                itemWith = this.width / (double)this.clipNumber;
                leftClipNumber = numPage % this.clipNumber;
                if (leftClipNumber == 1) {
                    leftClipNumber = this.clipNumber + 1;
                }
            }
            for (int i = 0; i < numPage; ++i) {
                double x;
                int index;
                int n = index = leftClipNumber == 0 ? i : leftClipNumber + i - numPage;
                if (numPage - i <= leftClipNumber) {
                    this.clipNumber = leftClipNumber;
                    itemWith = this.width / (double)this.clipNumber;
                }
                Page page = ctx.getPage(i + 1);
                ST_Box pageSize = ctx.getPageSize(page);
                ST_Box clip = null;
                if (this.side == Side.Right) {
                    x = pageSize.getWidth() - itemWith * (double)(i + 1) - this.margin;
                    clip = new ST_Box((double)i * itemWith, 0.0, itemWith, this.height);
                    if (isClipNumber) {
                        x = pageSize.getWidth() - (double)(Math.floorMod(index, this.clipNumber) + 1) * itemWith - this.margin;
                        clip = new ST_Box((double)Math.floorMod(index, this.clipNumber) * itemWith, 0.0, itemWith, this.height);
                    }
                } else {
                    x = 0.0 - itemWith * (double)(numPage - 1 - i) + this.margin;
                    clip = new ST_Box((double)(numPage - 1 - i) * itemWith, 0.0, itemWith, this.height);
                    if (isClipNumber) {
                        x = 0.0 - itemWith * (double)Math.floorMod(index, this.clipNumber) + this.margin;
                        clip = new ST_Box((double)Math.floorMod(index, this.clipNumber) * itemWith, 0.0, itemWith, this.height);
                    }
                }
                double y = this.offset == null ? pageSize.getHeight() / 2.0 - this.height / 2.0 : this.offset;
                ST_RefID ref = ctx.getPageObjectId(i + 1).ref();
                StampAnnot annot = new StampAnnot().setID(idProvider.incrementAndGet()).setBoundary(new ST_Box(x, y, this.width, this.height)).setPageRef(ref).setClip(clip);
                res.add(annot);
            }
        } else {
            double itemHeight = this.height / (double)numPage;
            if (isClipNumber) {
                itemHeight = this.height / (double)this.clipNumber;
                leftClipNumber = numPage % this.clipNumber;
                if (leftClipNumber == 1) {
                    leftClipNumber = this.clipNumber + 1;
                }
            }
            for (int i = 0; i < numPage; ++i) {
                double y;
                int index;
                int n = index = leftClipNumber == 0 ? i : leftClipNumber + i - numPage;
                if (numPage - i <= leftClipNumber) {
                    this.clipNumber = leftClipNumber;
                    itemHeight = this.width / (double)this.clipNumber;
                }
                Page page = ctx.getPage(i + 1);
                ST_Box pageSize = ctx.getPageSize(page);
                double x = this.offset == null ? pageSize.getWidth() / 2.0 - this.width / 2.0 : this.offset;
                ST_Box clip = null;
                if (this.side == Side.Bottom) {
                    y = pageSize.getHeight() - itemHeight * (double)(i + 1) - this.margin;
                    clip = new ST_Box(0.0, itemHeight * (double)i, this.width, itemHeight);
                    if (isClipNumber) {
                        y = pageSize.getHeight() - (double)(Math.floorMod(index, this.clipNumber) + 1) * itemHeight - this.margin;
                        clip = new ST_Box(0.0, itemHeight * (double)Math.floorMod(index, this.clipNumber), this.width, itemHeight);
                    }
                } else {
                    y = 0.0 - itemHeight * (double)(numPage - 1 - i) + this.margin;
                    clip = new ST_Box(0.0, (double)(numPage - 1 - i) * itemHeight, this.width, itemHeight);
                    if (isClipNumber) {
                        y = 0.0 - itemHeight * (double)Math.floorMod(index, this.clipNumber) + this.margin;
                        clip = new ST_Box(0.0, (double)Math.floorMod(index, this.clipNumber) * itemHeight, this.width, itemHeight);
                    }
                }
                ST_RefID ref = ctx.getPageObjectId(i + 1).ref();
                StampAnnot annot = new StampAnnot().setID(idProvider.incrementAndGet()).setBoundary(new ST_Box(x, y, this.width, this.height)).setPageRef(ref).setClip(clip);
                res.add(annot);
            }
        }
        return res;
    }
}

