/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.sign.stamppos;

import java.util.ArrayList;
import java.util.List;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.signatures.appearance.StampAnnot;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.sign.SignIDProvider;
import org.ofdrw.sign.stamppos.StampAppearance;

public class NormalStampPos
implements StampAppearance {
    private int page;
    private double tlx;
    private double tly;
    private double width;
    private double height;

    public NormalStampPos(int page, double tlx, double tly, double width, double height) {
        this.page = page;
        this.tlx = tlx;
        this.tly = tly;
        this.width = width;
        this.height = height;
    }

    public int getPage() {
        return this.page;
    }

    public NormalStampPos setPage(int page) {
        this.page = page;
        return this;
    }

    public double getX() {
        return this.tlx;
    }

    public NormalStampPos setX(double tlx) {
        this.tlx = tlx;
        return this;
    }

    public double getY() {
        return this.tly;
    }

    public NormalStampPos setY(double tly) {
        this.tly = tly;
        return this;
    }

    public double getWidth() {
        return this.width;
    }

    public NormalStampPos setWidth(double width) {
        this.width = width;
        return this;
    }

    public double getHeight() {
        return this.height;
    }

    public NormalStampPos setHeight(double height) {
        this.height = height;
        return this;
    }

    @Override
    public List<StampAnnot> getAppearance(OFDReader ctx, SignIDProvider idProvider) {
        ST_RefID ref = ctx.getPageObjectId(this.page).ref();
        StampAnnot annot = new StampAnnot().setID(idProvider.incrementAndGet()).setBoundary(new ST_Box(this.tlx, this.tly, this.width, this.height)).setPageRef(ref);
        ArrayList<StampAnnot> res = new ArrayList<StampAnnot>(1);
        res.add(annot);
        return res;
    }
}

