/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.server.utils;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;
import org.noear.solon.Utils;
import org.noear.solon.admin.server.config.ServerProperties;
import org.noear.solon.core.handle.Context;

public class BasicAuthUtils {
    static final Charset UTF_8 = Charset.forName("UTF-8");

    public static String base64DecodeToStr(String value) {
        byte[] decodedValue = Base64.getDecoder().decode(value);
        return new String(decodedValue, UTF_8);
    }

    public static boolean basicAuth(Context ctx, ServerProperties serverProperties) throws IOException {
        if (serverProperties.getBasicAuth() == null || serverProperties.getBasicAuth().size() == 0) {
            return true;
        }
        String authorization = ctx.header("Authorization");
        if (Utils.isBlank((String)authorization)) {
            return false;
        }
        String nameAndPwd = BasicAuthUtils.base64DecodeToStr(authorization.substring(6));
        String[] upArr = nameAndPwd.split(":");
        if (upArr.length != 2) {
            return false;
        }
        String iptName = upArr[0];
        String iptPwd = upArr[1];
        return iptPwd.equals(serverProperties.getBasicAuth().get(iptName));
    }

    public static void response401(Context ctx) throws IOException {
        ctx.status(401);
        ctx.headerSet("WWW-Authenticate", "Basic realm=\"\u8bf7\u8f93\u5165Solon-Admin\u8bbf\u95ee\u8d26\u53f7\u5bc6\u7801\"");
        ctx.output("\u65e0\u6743\u9650\u8bbf\u95ee");
    }
}

