/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v50;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.neo4j.io.fs.ReadableChecksumChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.v50.LogEntryDetachedCheckpointV5_0;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;
import org.neo4j.storageengine.api.TransactionId;

public class DetachedCheckpointLogEntryParserV5_0
extends LogEntryParser {
    public static final int MAX_DESCRIPTION_LENGTH = 116;

    public DetachedCheckpointLogEntryParserV5_0() {
        super((byte)9);
    }

    @Override
    public LogEntry parse(KernelVersion version, ReadableChecksumChannel channel, LogPositionMarker marker, CommandReaderFactory commandReaderFactory) throws IOException {
        long logVersion = channel.getLong();
        long byteOffset = channel.getLong();
        long checkpointTimeMillis = channel.getLong();
        byte[] storeIdBuffer = new byte[64];
        channel.get(storeIdBuffer, storeIdBuffer.length);
        StoreId storeId = StoreIdSerialization.deserializeWithFixedSize((ByteBuffer)ByteBuffer.wrap(storeIdBuffer));
        TransactionId transactionId = new TransactionId(channel.getLong(), channel.getInt(), channel.getLong(), -1L);
        short reasonBytesLength = channel.getShort();
        byte[] bytes = new byte[116];
        channel.get(bytes, 116);
        String reason = new String(bytes, 0, (int)reasonBytesLength, StandardCharsets.UTF_8);
        channel.endChecksumAndValidate();
        return new LogEntryDetachedCheckpointV5_0(version, transactionId, new LogPosition(logVersion, byteOffset), checkpointTimeMillis, storeId, reason);
    }
}

