/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metrics.output;

import com.codahale.metrics.Counter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Locale;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.metrics.output.EventReporter;

public class CsvOutput
implements Lifecycle,
EventReporter {
    private final Config config;
    private final MetricRegistry registry;
    private final Log logger;
    private final KernelContext kernelContext;
    private ScheduledReporter csvReporter;
    private File outputPath;

    public CsvOutput(Config config, MetricRegistry registry, Log logger, KernelContext kernelContext) {
        this.config = config;
        this.registry = registry;
        this.logger = logger;
        this.kernelContext = kernelContext;
    }

    public void init() {
        File configuredPath = (File)this.config.get(MetricsSettings.csvPath);
        if (configuredPath == null) {
            throw new IllegalArgumentException(MetricsSettings.csvPath.name() + " configuration is required since " + MetricsSettings.csvEnabled.name() + " is enabled");
        }
        this.outputPath = CsvOutput.absoluteFileOrRelativeTo(this.kernelContext.storeDir(), configuredPath);
        this.csvReporter = CsvReporter.forRegistry((MetricRegistry)this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).formatFor(Locale.US).build(this.ensureDirectoryExists(this.outputPath));
    }

    public void start() {
        this.csvReporter.start(((Duration)this.config.get(MetricsSettings.csvInterval)).toMillis(), TimeUnit.MILLISECONDS);
        this.logger.info("Sending metrics to CSV file at " + this.outputPath);
    }

    public void stop() throws IOException {
        this.csvReporter.stop();
    }

    public void shutdown() {
        this.csvReporter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        ScheduledReporter scheduledReporter = this.csvReporter;
        synchronized (scheduledReporter) {
            this.csvReporter.report(gauges, counters, histograms, meters, timers);
        }
    }

    private File ensureDirectoryExists(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Could not create path for CSV files: " + dir.getAbsolutePath());
        }
        if (dir.isFile()) {
            throw new IllegalStateException("The given path for CSV files points to a file, but a directory is required: " + dir.getAbsolutePath());
        }
        return dir;
    }

    private static File absoluteFileOrRelativeTo(File baseDirectoryIfRelative, File absoluteOrRelativeFile) {
        return absoluteOrRelativeFile.isAbsolute() ? absoluteOrRelativeFile : new File(baseDirectoryIfRelative, absoluteOrRelativeFile.getPath());
    }
}

