/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.KeyValueMapEntry;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.RendererBridge;
import org.neo4j.cypherdsl.core.ast.TypedSubtree;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class MapExpression
extends TypedSubtree<Expression>
implements Expression {
    static MapExpression create(Map<String, Object> map) {
        Object[] args = new Object[map.size() * 2];
        int i = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Literal value = entry.getValue();
            args[i++] = entry.getKey();
            args[i++] = value instanceof Expression ? value : Cypher.literalOf(value);
        }
        return MapExpression.create(false, args);
    }

    static MapExpression create(boolean sort, Object ... input) {
        Assertions.isTrue(input.length % 2 == 0, "Need an even number of input parameters");
        ArrayList<Expression> newContent = new ArrayList<Expression>(input.length / 2);
        HashSet<String> knownKeys = new HashSet<String>();
        for (int i = 0; i < input.length; i += 2) {
            String key;
            Object keyCandidate = input[i];
            if (keyCandidate instanceof String) {
                String v;
                key = v = (String)keyCandidate;
            } else if (keyCandidate instanceof Property) {
                Property property = (Property)keyCandidate;
                List<PropertyLookup> names = property.getNames();
                if (names.size() != 1) {
                    throw new IllegalArgumentException("Nested properties are not supported in a map expression");
                }
                key = names.get(0).getPropertyKeyName().getValue();
            } else {
                throw new IllegalStateException("Key needs to be of type String or Property.");
            }
            Assertions.isInstanceOf(Expression.class, input[i + 1], "Value needs to be of type Expression.");
            Assertions.isTrue(!knownKeys.contains(input[i]), "Duplicate key '" + String.valueOf(input[i]) + "'");
            KeyValueMapEntry entry = KeyValueMapEntry.create(key, (Expression)input[i + 1]);
            newContent.add(entry);
            knownKeys.add(entry.getKey());
        }
        if (sort) {
            newContent.sort(Comparator.comparing(o -> ((KeyValueMapEntry)o).getKey()));
        }
        return new MapExpression((List<Expression>)newContent);
    }

    static MapExpression withEntries(List<Expression> entries) {
        return new MapExpression(entries);
    }

    private MapExpression(List<Expression> children) {
        super(children);
    }

    MapExpression addEntries(List<Expression> entries) {
        ArrayList<Expression> newContent = new ArrayList<Expression>(this.children.size() + entries.size());
        newContent.addAll(this.children);
        newContent.addAll(entries);
        return new MapExpression((List<Expression>)newContent);
    }

    @Override
    protected Visitable prepareVisit(Expression child) {
        return Expressions.nameOrExpression(child);
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

