/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionCondition;
import org.neo4j.cypherdsl.core.MapProjection;
import org.neo4j.cypherdsl.core.support.LRUCache;
import org.neo4j.cypherdsl.core.utils.Assertions;
import org.neo4j.cypherdsl.core.utils.Strings;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public class SymbolicName
implements Expression {
    private static final Map<String, SymbolicName> CACHE = Collections.synchronizedMap(new LRUCache(32));
    private final String value;

    static SymbolicName of(String name) {
        Assertions.hasText(name, "Name must not be empty.");
        Assertions.isTrue(Strings.isIdentifier(name), "Name must be a valid identifier.");
        return CACHE.computeIfAbsent(name, SymbolicName::new);
    }

    static SymbolicName unsafe(String name) {
        Assertions.hasText(name, "Name must not be empty.");
        return new SymbolicName(name);
    }

    static SymbolicName unresolved() {
        return new SymbolicName(null);
    }

    private SymbolicName(String value) {
        this.value = value;
    }

    @API(status=API.Status.INTERNAL)
    public String getValue() {
        return this.value;
    }

    public SymbolicName concat(String otherValue) {
        Assertions.notNull(otherValue, "Value to concat must not be null.");
        if (otherValue.isEmpty()) {
            return this;
        }
        return SymbolicName.of(this.value + otherValue);
    }

    public Condition asCondition() {
        return new ExpressionCondition(this);
    }

    public MapProjection project(List<Object> entries) {
        return this.project(entries.toArray());
    }

    public MapProjection project(Object ... entries) {
        return MapProjection.create(this, entries);
    }

    public String toString() {
        return this.value != null ? "SymbolicName{name='" + this.value + '\'' + '}' : "Unresolved SymbolicName";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.value == null) {
            return false;
        }
        SymbolicName that = (SymbolicName)o;
        return this.value.equals(that.value);
    }

    boolean isResolved() {
        return this.value != null;
    }

    public int hashCode() {
        return this.value == null ? super.hashCode() : Objects.hash(this.value);
    }
}

