/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Asterisk;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class PropertyLookup
implements Expression {
    private static final PropertyLookup WILDCARD = new PropertyLookup(Asterisk.INSTANCE, false);
    private final Expression propertyKeyName;
    private final boolean dynamicLookup;

    static PropertyLookup forName(String name) {
        Assertions.hasText(name, "The property's name is required.");
        return new PropertyLookup(SymbolicName.unsafe(name), false);
    }

    static PropertyLookup forExpression(Expression expression) {
        Assertions.notNull(expression, "The expression is required");
        return new PropertyLookup(expression, true);
    }

    static PropertyLookup wildcard() {
        return WILDCARD;
    }

    private PropertyLookup(Expression propertyKeyName, boolean dynamicLookup) {
        this.propertyKeyName = propertyKeyName;
        this.dynamicLookup = dynamicLookup;
    }

    @API(status=API.Status.INTERNAL)
    SymbolicName getPropertyKeyName() {
        Assertions.isTrue(this != WILDCARD, "The wildcard property lookup does not reference a specific property!");
        return (SymbolicName)this.propertyKeyName;
    }

    @API(status=API.Status.INTERNAL)
    public boolean isDynamicLookup() {
        return this.dynamicLookup;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.propertyKeyName.accept(visitor);
        visitor.leave(this);
    }
}

