/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AbstractNode;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.NodeLabel;
import org.neo4j.cypherdsl.core.Properties;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="2021.1.0")
public abstract class NodeBase<SELF extends Node>
extends AbstractNode
implements Node {
    private volatile SymbolicName symbolicName;
    final List<NodeLabel> labels;
    final Properties properties;

    protected NodeBase(String primaryLabel, String ... additionalLabels) {
        this((SymbolicName)null, primaryLabel, (MapExpression)null, additionalLabels);
    }

    protected NodeBase(SymbolicName symbolicName, List<NodeLabel> labels, Properties properties) {
        this.symbolicName = symbolicName;
        this.labels = new ArrayList<NodeLabel>(labels);
        this.properties = properties;
    }

    public final SELF named(String newSymbolicName) {
        Assertions.hasText(newSymbolicName, "Symbolic name is required.");
        return this.named(SymbolicName.of(newSymbolicName));
    }

    public abstract SELF named(SymbolicName var1);

    @Override
    public final SELF withProperties(Object ... keysAndValues) {
        MapExpression newProperties = null;
        if (keysAndValues != null && keysAndValues.length != 0) {
            newProperties = MapExpression.create(keysAndValues);
        }
        return (SELF)this.withProperties(newProperties);
    }

    @Override
    public final SELF withProperties(Map<String, Object> newProperties) {
        return (SELF)this.withProperties(MapExpression.create(newProperties));
    }

    @Override
    public abstract SELF withProperties(MapExpression var1);

    protected final Properties getProperties() {
        return this.properties;
    }

    @Override
    public final List<NodeLabel> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    @Override
    public final Optional<SymbolicName> getSymbolicName() {
        return Optional.ofNullable(this.symbolicName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SymbolicName getRequiredSymbolicName() {
        SymbolicName requiredSymbolicName = this.symbolicName;
        if (requiredSymbolicName == null) {
            NodeBase nodeBase = this;
            synchronized (nodeBase) {
                requiredSymbolicName = this.symbolicName;
                if (requiredSymbolicName == null) {
                    requiredSymbolicName = this.symbolicName = SymbolicName.unresolved();
                }
            }
        }
        return requiredSymbolicName;
    }

    NodeBase() {
        this(null, Collections.emptyList(), null);
    }

    NodeBase(SymbolicName symbolicName, String primaryLabel, MapExpression properties, String ... additionalLabels) {
        this(symbolicName, NodeBase.assertLabels(primaryLabel, additionalLabels), Properties.create(properties));
    }

    @Override
    public final void accept(Visitor visitor) {
        visitor.enter(this);
        this.getSymbolicName().ifPresent(s -> s.accept(visitor));
        this.labels.forEach(label -> label.accept(visitor));
        Visitable.visitIfNotNull(this.properties, visitor);
        visitor.leave(this);
    }

    private static List<NodeLabel> assertLabels(String primaryLabel, String[] additionalLabels) {
        Assertions.hasText(primaryLabel, "A primary label is required.");
        if (additionalLabels != null) {
            for (String additionalLabel : additionalLabels) {
                Assertions.hasText(additionalLabel, "An empty label is not allowed.");
            }
        }
        ArrayList<NodeLabel> labels = new ArrayList<NodeLabel>();
        labels.add(new NodeLabel(primaryLabel));
        labels.addAll(Arrays.stream(additionalLabels).map(NodeLabel::new).collect(Collectors.toList()));
        return labels;
    }
}

