/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public abstract class Case
implements Visitable {
    private CaseElse caseElse;
    private final List<CaseWhenThen> caseWhenThens;

    static Case create(Expression caseExpression) {
        return new SimpleCase(caseExpression, new ArrayList());
    }

    static Case create() {
        return new GenericCase(new ArrayList());
    }

    Case(List<CaseWhenThen> caseWhenThens) {
        this.caseWhenThens = caseWhenThens;
    }

    abstract Expression getCaseExpression();

    void setCaseElse(CaseElse caseElse) {
        this.caseElse = caseElse;
    }

    List<CaseWhenThen> getCaseWhenThens() {
        return this.caseWhenThens;
    }

    public OngoingWhenThen when(Expression nextExpression) {
        return new OngoingWhenThen(nextExpression);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        if (this.getCaseExpression() != null) {
            this.getCaseExpression().accept(visitor);
        }
        this.getCaseWhenThens().forEach(caseWhenThen -> caseWhenThen.accept(visitor));
        if (this.caseElse != null) {
            this.caseElse.accept(visitor);
        }
        visitor.leave(this);
    }

    @API(status=API.Status.INTERNAL, since="1.0")
    public final class CaseElse
    implements Visitable {
        private final Expression elseExpression;

        private CaseElse(Expression elseExpression) {
            this.elseExpression = elseExpression;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.enter(this);
            this.elseExpression.accept(visitor);
            visitor.leave(this);
        }
    }

    @API(status=API.Status.INTERNAL, since="1.0")
    public final class CaseWhenThen
    implements Visitable {
        private final Expression whenExpression;
        private final Expression thenExpression;

        private CaseWhenThen(Expression whenExpression, Expression thenExpression) {
            this.whenExpression = whenExpression;
            this.thenExpression = thenExpression;
        }

        public OngoingWhenThen when(Expression nextExpression) {
            return new OngoingWhenThen(nextExpression);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.enter(this);
            this.whenExpression.accept(visitor);
            visitor.leave(this);
            this.thenExpression.accept(visitor);
        }
    }

    @API(status=API.Status.INTERNAL, since="1.0")
    public final class OngoingWhenThen {
        final Expression whenExpression;

        private OngoingWhenThen(Expression whenExpression) {
            this.whenExpression = whenExpression;
        }

        public CaseEnding then(Expression expression) {
            CaseWhenThen caseWhenThen = new CaseWhenThen(this.whenExpression, expression);
            Case.this.getCaseWhenThens().add(caseWhenThen);
            if (Case.this.getCaseExpression() != null) {
                return new SimpleCase.EndingSimpleCase(Case.this.getCaseExpression(), Case.this.getCaseWhenThens());
            }
            return new GenericCase.EndingGenericCase(Case.this.getCaseWhenThens());
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.0")
    public static class GenericCase
    extends Case {
        private GenericCase(List<CaseWhenThen> caseWhenThens) {
            super(caseWhenThens);
        }

        @Override
        Expression getCaseExpression() {
            return null;
        }

        public static final class EndingGenericCase
        extends GenericCase
        implements CaseEnding {
            private EndingGenericCase(List<CaseWhenThen> caseWhenThens) {
                super(caseWhenThens);
            }

            @Override
            public CaseEnding elseDefault(Expression defaultExpression) {
                this.setCaseElse(new CaseElse(defaultExpression));
                return this;
            }
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.0")
    public static class SimpleCase
    extends Case {
        private final Expression caseExpression;

        private SimpleCase(Expression caseExpression, List<CaseWhenThen> caseWhenThens) {
            super(caseWhenThens);
            this.caseExpression = caseExpression;
        }

        @Override
        Expression getCaseExpression() {
            return this.caseExpression;
        }

        public static final class EndingSimpleCase
        extends SimpleCase
        implements CaseEnding {
            private EndingSimpleCase(Expression caseExpression, List<CaseWhenThen> caseWhenThens) {
                super(caseExpression, caseWhenThens);
            }

            @Override
            public CaseEnding elseDefault(Expression defaultExpression) {
                this.setCaseElse(new CaseElse(defaultExpression));
                return this;
            }
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.0")
    public static interface CaseEnding
    extends Condition {
        public OngoingWhenThen when(Expression var1);

        public CaseEnding elseDefault(Expression var1);
    }
}

