/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.com.storecopy.FileMoveAction;
import org.neo4j.com.storecopy.FileMoveActionInformer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.StoreType;

public class FileMoveProvider {
    private final FileMoveActionInformer fileMoveActionInformer;
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;

    public FileMoveProvider(PageCache pageCache, FileSystemAbstraction fs) {
        this(pageCache, StoreType::canBeManagedByPageCache, fs);
    }

    public FileMoveProvider(PageCache pageCache, FileMoveActionInformer fileMoveActionInformer, FileSystemAbstraction fs) {
        this.pageCache = pageCache;
        this.fileMoveActionInformer = fileMoveActionInformer;
        this.fs = fs;
    }

    public Stream<FileMoveAction> traverseForMoving(File dir) {
        return this.traverseForMoving(dir, dir);
    }

    private Stream<FileMoveAction> traverseForMoving(File dir, File basePath) {
        return Stream.of(dir).flatMap(d -> this.expandTraverseFiles((File)d, basePath));
    }

    private Stream<FileMoveAction> expandTraverseFiles(File dir, File basePath) {
        List<File> listing = this.listFiles(dir);
        if (listing == null) {
            listing = Collections.singletonList(dir);
            basePath = dir.getParentFile();
        }
        File base = basePath;
        Stream<File> files = listing.stream().filter(this::isFile);
        Stream<File> dirs = listing.stream().filter(this::isDirectory);
        Stream<FileMoveAction> moveFiles = files.map(f -> this.moveFileCorrectly((File)f, base));
        Stream traverseDirectories = dirs.flatMap(d -> this.traverseForMoving((File)d, base));
        return Stream.concat(moveFiles, traverseDirectories);
    }

    private boolean isFile(File file) {
        if (this.fileMoveActionInformer.shouldBeManagedByPageCache(file.getName())) {
            return !this.pageCache.getCachedFileSystem().isDirectory(file);
        }
        return !this.fs.isDirectory(file);
    }

    private boolean isDirectory(File file) {
        if (this.fileMoveActionInformer.shouldBeManagedByPageCache(file.getName())) {
            return this.pageCache.getCachedFileSystem().isDirectory(file);
        }
        return this.fs.isDirectory(file);
    }

    private List<File> listFiles(File dir) {
        File[] cachedFiles = this.pageCache.getCachedFileSystem().listFiles(dir);
        File[] fsaFiles = this.fs.listFiles(dir);
        if (cachedFiles == null && fsaFiles == null) {
            return null;
        }
        Stream files = Stream.concat(Optional.ofNullable(cachedFiles).map(Arrays::stream).orElse(Stream.empty()), Optional.ofNullable(fsaFiles).map(Arrays::stream).orElse(Stream.empty()));
        return files.distinct().collect(Collectors.toList());
    }

    private FileMoveAction moveFileCorrectly(File fileToMove, File basePath) {
        if (this.fileMoveActionInformer.shouldBeManagedByPageCache(fileToMove.getName())) {
            return FileMoveAction.moveViaPageCache(fileToMove, this.pageCache);
        }
        return FileMoveAction.moveViaFileSystem(fileToMove, basePath);
    }
}

