/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.election;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageHolder;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AtomicBroadcastMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerMessage;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.cluster.protocol.election.ElectionContext;
import org.neo4j.cluster.protocol.election.ElectionMessage;
import org.neo4j.cluster.protocol.election.ElectionRole;
import org.neo4j.cluster.statemachine.State;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.logging.Log;

public enum ElectionState implements State<ElectionContext, ElectionMessage>
{
    start{

        public ElectionState handle(ElectionContext context, Message<ElectionMessage> message, MessageHolder outgoing) {
            if (message.getMessageType() == ElectionMessage.created) {
                context.created();
                return election;
            }
            if (message.getMessageType() == ElectionMessage.join) {
                return election;
            }
            return this;
        }
    }
    ,
    election{

        public ElectionState handle(ElectionContext context, Message<ElectionMessage> message, MessageHolder outgoing) {
            Log log = context.getLog(ElectionState.class);
            switch (message.getMessageType()) {
                case demote: {
                    boolean isElector;
                    if (!context.electionOk()) {
                        log.warn("Context says election is not OK to proceed. Failed instances are: " + context.getFailed() + ", cluster members are: " + context.getMembers());
                        break;
                    }
                    InstanceId demoteNode = (InstanceId)message.getPayload();
                    context.nodeFailed(demoteNode);
                    if (!context.isInCluster()) break;
                    List aliveInstances = Iterables.asList(context.getAlive());
                    Collections.sort(aliveInstances);
                    boolean bl = isElector = aliveInstances.indexOf(context.getMyId()) == 0;
                    if (!isElector) break;
                    log.debug("I (" + context.getMyId() + ") am the elector, executing the election");
                    Iterable<String> rolesRequiringElection = context.getRolesRequiringElection();
                    for (String role : rolesRequiringElection) {
                        if (!context.isElectionProcessInProgress(role)) {
                            log.debug("Starting election process for role " + role);
                            context.startElectionProcess(role);
                            for (Map.Entry<InstanceId, URI> server : context.getMembers().entrySet()) {
                                if (context.getFailed().contains(server.getKey())) continue;
                                outgoing.offer(Message.to(ElectionMessage.vote, server.getValue(), context.voteRequestForRole(new ElectionRole(role))));
                            }
                            context.setTimeout("election-" + role, Message.timeout(ElectionMessage.electionTimeout, message, new ElectionTimeoutData(role, message)));
                            continue;
                        }
                        log.debug("Election already in progress for role " + role);
                    }
                    break;
                }
                case performRoleElections: {
                    if (!context.electionOk()) {
                        log.warn("Context says election is not OK to proceed. Failed instances are: " + context.getFailed() + ", cluster members are: " + context.getMembers());
                        break;
                    }
                    if (!context.isInCluster()) break;
                    boolean isElector = context.isElector();
                    if (isElector) {
                        context.getLog(ElectionState.class).info("I am the elector, doing election...");
                        List<ElectionRole> rolesRequiringElection = context.getPossibleRoles();
                        for (ElectionRole role : rolesRequiringElection) {
                            String roleName = role.getName();
                            if (!context.isElectionProcessInProgress(roleName)) {
                                context.getLog(ElectionState.class).debug("Starting election process for role " + roleName);
                                context.startElectionProcess(roleName);
                                boolean sentSome = false;
                                for (Map.Entry<InstanceId, URI> server : context.getMembers().entrySet()) {
                                    if (context.isFailed(server.getKey()) || server.getKey().equals(context.getElected(roleName))) continue;
                                    outgoing.offer(Message.to(ElectionMessage.vote, server.getValue(), context.voteRequestForRole(role)));
                                    sentSome = true;
                                }
                                if (!sentSome) {
                                    outgoing.offer(Message.internal(ElectionMessage.vote, context.voteRequestForRole(new ElectionRole(roleName))));
                                    continue;
                                }
                                context.setTimeout("election-" + roleName, Message.timeout(ElectionMessage.electionTimeout, message, new ElectionTimeoutData(roleName, message)));
                                continue;
                            }
                            log.debug("Election already in progress for role " + roleName);
                        }
                        break;
                    }
                    Set aliveInstances = Iterables.asSet(context.getAlive());
                    aliveInstances.removeAll(context.getFailed());
                    List adjustedAlive = Iterables.asList((Iterable)aliveInstances);
                    Collections.sort(adjustedAlive);
                    context.getLog(ElectionState.class).info("I am NOT the elector, sending to " + adjustedAlive);
                    outgoing.offer(message.setHeader("to", context.getUriForId((InstanceId)Iterables.firstOrNull((Iterable)adjustedAlive)).toString()));
                    break;
                }
                case vote: {
                    Object request = message.getPayload();
                    ElectionContext.VoteRequest voteRequest = (ElectionContext.VoteRequest)request;
                    outgoing.offer(Message.respond(ElectionMessage.voted, message, new ElectionMessage.VersionedVotedData(voteRequest.getRole(), context.getMyId(), context.getCredentialsForRole(voteRequest.getRole()), voteRequest.getVersion())));
                    break;
                }
                case voted: {
                    ElectionMessage.VotedData data = (ElectionMessage.VotedData)message.getPayload();
                    long version = -1L;
                    if (data instanceof ElectionMessage.VersionedVotedData) {
                        version = ((ElectionMessage.VersionedVotedData)data).getVersion();
                    }
                    boolean accepted = context.voted(data.getRole(), data.getInstanceId(), data.getElectionCredentials(), version);
                    String voter = message.hasHeader("from") ? message.getHeader("from") : "I";
                    log.debug(voter + " voted " + data + " which i " + (accepted ? "accepted" : "did not accept"));
                    if (!accepted) break;
                    InstanceId currentElected = context.getElected(data.getRole());
                    if (context.getVoteCount(data.getRole()) == context.getNeededVoteCount()) {
                        InstanceId winner = context.getElectionWinner(data.getRole());
                        context.cancelTimeout("election-" + data.getRole());
                        context.forgetElection(data.getRole());
                        if (winner != null) {
                            log.debug("Elected " + winner + " as " + data.getRole());
                            ClusterMessage.VersionedConfigurationStateChange configurationChangeState = context.newConfigurationStateChange();
                            configurationChangeState.elected(data.getRole(), winner);
                            outgoing.offer(Message.internal(AtomicBroadcastMessage.broadcast, configurationChangeState));
                            break;
                        }
                        log.warn("Election could not pick a winner");
                        if (currentElected == null) break;
                        ClusterMessage.ConfigurationChangeState configurationChangeState = new ClusterMessage.ConfigurationChangeState();
                        configurationChangeState.unelected(data.getRole(), currentElected);
                        outgoing.offer(Message.internal(ProposerMessage.propose, configurationChangeState));
                        break;
                    }
                    if (context.getVoteCount(data.getRole()) != context.getNeededVoteCount() - 1 || currentElected == null || context.hasCurrentlyElectedVoted(data.getRole(), currentElected)) break;
                    outgoing.offer(Message.to(ElectionMessage.vote, context.getUriForId(currentElected), context.voteRequestForRole(new ElectionRole(data.getRole()))));
                    break;
                }
                case electionTimeout: {
                    ElectionTimeoutData electionTimeoutData = (ElectionTimeoutData)message.getPayload();
                    log.warn(String.format("Election timed out for '%s'- trying again", electionTimeoutData.getRole()));
                    context.forgetElection(electionTimeoutData.getRole());
                    outgoing.offer(electionTimeoutData.getMessage());
                    break;
                }
                case leave: {
                    return start;
                }
            }
            return this;
        }
    };


    public static class ElectionTimeoutData {
        private final String role;
        private final Message message;

        public ElectionTimeoutData(String role, Message message) {
            this.role = role;
            this.message = message;
        }

        public String getRole() {
            return this.role;
        }

        public Message getMessage() {
            return this.message;
        }
    }
}

