/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.cluster;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.cluster.InstanceId;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ClusterConfiguration {
    public static final String COORDINATOR = "coordinator";
    private final String name;
    private final Log log;
    private final List<URI> candidateMembers;
    private volatile Map<InstanceId, URI> members;
    private volatile Map<String, InstanceId> roles = new HashMap<String, InstanceId>();

    public ClusterConfiguration(String name, LogProvider logProvider, String ... members) {
        this.name = name;
        this.log = logProvider.getLog(this.getClass());
        this.candidateMembers = new ArrayList<URI>();
        for (String node : members) {
            try {
                this.candidateMembers.add(new URI(node));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        this.members = new HashMap<InstanceId, URI>();
    }

    public ClusterConfiguration(String name, LogProvider logProvider, Collection<URI> members) {
        this.name = name;
        this.log = logProvider.getLog(this.getClass());
        this.candidateMembers = new ArrayList<URI>(members);
        this.members = new HashMap<InstanceId, URI>();
    }

    public ClusterConfiguration(ClusterConfiguration copy) {
        this(copy, copy.log);
    }

    private ClusterConfiguration(ClusterConfiguration copy, Log log) {
        this.name = copy.name;
        this.log = log;
        this.candidateMembers = new ArrayList<URI>(copy.candidateMembers);
        this.roles = new HashMap<String, InstanceId>(copy.roles);
        this.members = new HashMap<InstanceId, URI>(copy.members);
    }

    public void joined(InstanceId joinedInstanceId, URI instanceUri) {
        if (instanceUri.equals(this.members.get(joinedInstanceId))) {
            return;
        }
        HashMap<InstanceId, URI> newMembers = new HashMap<InstanceId, URI>(this.members);
        newMembers.put(joinedInstanceId, instanceUri);
        this.members = newMembers;
    }

    public void left(InstanceId leftInstanceId) {
        this.log.info("Instance " + leftInstanceId + " is leaving the cluster");
        HashMap<InstanceId, URI> newMembers = new HashMap<InstanceId, URI>(this.members);
        newMembers.remove(leftInstanceId);
        this.members = newMembers;
        Iterator<Map.Entry<String, InstanceId>> entries = this.roles.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, InstanceId> roleEntry = entries.next();
            if (!roleEntry.getValue().equals(leftInstanceId)) continue;
            this.log.info("Removed role " + roleEntry.getValue() + " from leaving instance " + roleEntry.getKey());
            entries.remove();
        }
    }

    public void elected(String name, InstanceId electedInstanceId) {
        assert (this.members.containsKey(electedInstanceId));
        HashMap<String, InstanceId> newRoles = new HashMap<String, InstanceId>(this.roles);
        newRoles.put(name, electedInstanceId);
        this.roles = newRoles;
    }

    public void unelected(String roleName) {
        assert (this.roles.containsKey(roleName));
        HashMap<String, InstanceId> newRoles = new HashMap<String, InstanceId>(this.roles);
        newRoles.remove(roleName);
        this.roles = newRoles;
    }

    public void setMembers(Map<InstanceId, URI> members) {
        this.members = new HashMap<InstanceId, URI>(members);
    }

    public void setRoles(Map<String, InstanceId> roles) {
        for (InstanceId electedInstanceId : roles.values()) {
            assert (this.members.containsKey(electedInstanceId));
        }
        this.roles = new HashMap<String, InstanceId>(roles);
    }

    public Iterable<InstanceId> getMemberIds() {
        return this.members.keySet();
    }

    public Map<InstanceId, URI> getMembers() {
        return this.members;
    }

    public List<URI> getMemberURIs() {
        return Iterables.asList(this.members.values());
    }

    public String getName() {
        return this.name;
    }

    public Map<String, InstanceId> getRoles() {
        return this.roles;
    }

    public void left() {
        this.members = new HashMap<InstanceId, URI>();
        this.roles = new HashMap<String, InstanceId>();
    }

    public void removeElected(String roleName) {
        HashMap<String, InstanceId> newRoles = new HashMap<String, InstanceId>(this.roles);
        InstanceId removed = (InstanceId)newRoles.remove(roleName);
        this.roles = newRoles;
        this.log.info("Removed role " + roleName + " from instance " + removed);
    }

    public InstanceId getElected(String roleName) {
        return this.roles.get(roleName);
    }

    public Iterable<String> getRolesOf(InstanceId node) {
        return Iterables.map(Map.Entry::getKey, (Iterable)Iterables.filter(item -> ((InstanceId)item.getValue()).equals(node), this.roles.entrySet()));
    }

    public URI getUriForId(InstanceId node) {
        return this.members.get(node);
    }

    public InstanceId getIdForUri(URI fromUri) {
        for (Map.Entry<InstanceId, URI> serverIdURIEntry : this.members.entrySet()) {
            if (!serverIdURIEntry.getValue().equals(fromUri)) continue;
            return serverIdURIEntry.getKey();
        }
        return null;
    }

    public ClusterConfiguration snapshot(Log log) {
        return new ClusterConfiguration(this, log);
    }

    public String toString() {
        return "Name:" + this.name + " Nodes:" + this.members + " Roles:" + this.roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterConfiguration that = (ClusterConfiguration)o;
        if (!this.candidateMembers.equals(that.candidateMembers)) {
            return false;
        }
        if (!this.members.equals(that.members)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.roles.equals(that.roles);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.candidateMembers.hashCode();
        result = 31 * result + this.members.hashCode();
        result = 31 * result + this.roles.hashCode();
        return result;
    }
}

