/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.protocol.ConfigurationContext;
import org.neo4j.cluster.protocol.LoggingContext;
import org.neo4j.cluster.protocol.TimeoutsContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.CommonContextState;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class AbstractContextImpl
implements TimeoutsContext,
LoggingContext,
ConfigurationContext {
    protected final InstanceId me;
    protected final CommonContextState commonState;
    protected final LogProvider logProvider;
    protected final Timeouts timeouts;

    AbstractContextImpl(InstanceId me, CommonContextState commonState, LogProvider logProvider, Timeouts timeouts) {
        this.me = me;
        this.commonState = commonState;
        this.logProvider = logProvider;
        this.timeouts = timeouts;
    }

    public Log getLog(Class loggingClass) {
        return this.logProvider.getLog(loggingClass);
    }

    @Override
    public void setTimeout(Object key, Message<? extends MessageType> timeoutMessage) {
        this.timeouts.setTimeout(key, timeoutMessage);
    }

    @Override
    public long getTimeoutFor(Message<? extends MessageType> timeoutMessage) {
        return this.timeouts.getTimeoutFor(timeoutMessage);
    }

    @Override
    public Message<? extends MessageType> cancelTimeout(Object key) {
        return this.timeouts.cancelTimeout(key);
    }

    @Override
    public List<URI> getMemberURIs() {
        return Iterables.asList(this.commonState.configuration().getMemberURIs());
    }

    @Override
    public InstanceId getMyId() {
        return this.me;
    }

    @Override
    public URI boundAt() {
        return this.commonState.boundAt();
    }

    @Override
    public Map<InstanceId, URI> getMembers() {
        return this.commonState.configuration().getMembers();
    }

    @Override
    public InstanceId getCoordinator() {
        return this.commonState.configuration().getElected("coordinator");
    }

    @Override
    public URI getUriForId(InstanceId node) {
        return this.commonState.configuration().getUriForId(node);
    }

    @Override
    public InstanceId getIdForUri(URI uri) {
        return this.commonState.configuration().getIdForUri(uri);
    }

    @Override
    public synchronized boolean isMe(InstanceId server) {
        return this.me.equals(server);
    }
}

