/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.protocol.atomicbroadcast.multipaxos;

import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.election.ElectionCredentials;

public class Vote
implements Comparable<Vote> {
    private final InstanceId suggestedNode;
    private final ElectionCredentials voteCredentials;

    public Vote(InstanceId suggestedNode, ElectionCredentials voteCredentials) {
        this.suggestedNode = suggestedNode;
        this.voteCredentials = voteCredentials;
    }

    public InstanceId getSuggestedNode() {
        return this.suggestedNode;
    }

    public Comparable<ElectionCredentials> getCredentials() {
        return this.voteCredentials;
    }

    public String toString() {
        return this.suggestedNode + ":" + this.voteCredentials;
    }

    @Override
    public int compareTo(Vote o) {
        return this.voteCredentials.compareTo(o.voteCredentials);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vote vote = (Vote)o;
        if (!this.suggestedNode.equals(vote.suggestedNode)) {
            return false;
        }
        return this.voteCredentials.equals(vote.voteCredentials);
    }

    public int hashCode() {
        int result = this.suggestedNode.hashCode();
        result = 31 * result + this.voteCredentials.hashCode();
        return result;
    }
}

