/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster.member.paxos;

import java.net.URI;
import org.neo4j.cluster.BindingListener;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.BindingNotifier;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.cluster.member.paxos.MemberIsAvailable;
import org.neo4j.cluster.member.paxos.MemberIsUnavailable;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcast;
import org.neo4j.cluster.protocol.atomicbroadcast.AtomicBroadcastSerializer;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.Payload;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class PaxosClusterMemberAvailability
implements ClusterMemberAvailability,
Lifecycle {
    private volatile URI serverClusterId;
    private Log log;
    protected AtomicBroadcastSerializer serializer;
    private final InstanceId myId;
    private BindingNotifier binding;
    private AtomicBroadcast atomicBroadcast;
    private BindingListener bindingListener;
    private ObjectInputStreamFactory objectInputStreamFactory;
    private ObjectOutputStreamFactory objectOutputStreamFactory;

    public PaxosClusterMemberAvailability(InstanceId myId, BindingNotifier binding, AtomicBroadcast atomicBroadcast, LogProvider logProvider, ObjectInputStreamFactory objectInputStreamFactory, ObjectOutputStreamFactory objectOutputStreamFactory) {
        this.myId = myId;
        this.binding = binding;
        this.atomicBroadcast = atomicBroadcast;
        this.objectInputStreamFactory = objectInputStreamFactory;
        this.objectOutputStreamFactory = objectOutputStreamFactory;
        this.log = logProvider.getLog(this.getClass());
        this.bindingListener = me -> {
            this.serverClusterId = me;
            this.log.info("Listening at:" + me);
        };
    }

    public void init() {
        this.serializer = new AtomicBroadcastSerializer(this.objectInputStreamFactory, this.objectOutputStreamFactory);
        this.binding.addBindingListener(this.bindingListener);
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
        this.binding.removeBindingListener(this.bindingListener);
    }

    @Override
    public void memberIsAvailable(String role, URI roleUri, StoreId storeId) {
        try {
            MemberIsAvailable message = new MemberIsAvailable(role, this.myId, this.serverClusterId, roleUri, storeId);
            Payload payload = this.serializer.broadcast(message);
            this.atomicBroadcast.broadcast(payload);
        }
        catch (Throwable e) {
            this.log.warn("Could not distribute member availability", e);
        }
    }

    @Override
    public void memberIsUnavailable(String role) {
        try {
            MemberIsUnavailable message = new MemberIsUnavailable(role, this.myId, this.serverClusterId);
            Payload payload = this.serializer.broadcast(message);
            this.atomicBroadcast.broadcast(payload);
        }
        catch (Throwable e) {
            this.log.warn("Could not distribute member unavailability", e);
        }
    }
}

