/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.cluster.DelayedDirectExecutor;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageHolder;
import org.neo4j.cluster.com.message.MessageProcessor;
import org.neo4j.cluster.com.message.MessageSender;
import org.neo4j.cluster.com.message.MessageSource;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.cluster.statemachine.StateMachine;
import org.neo4j.cluster.statemachine.StateTransitionListener;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class StateMachines
implements MessageProcessor,
MessageSource {
    private final Log log;
    private final Monitor monitor;
    private final MessageSender sender;
    private DelayedDirectExecutor executor;
    private Executor stateMachineExecutor;
    private Timeouts timeouts;
    private final Map<Class<? extends MessageType>, StateMachine> stateMachines = new LinkedHashMap<Class<? extends MessageType>, StateMachine>();
    private final List<MessageProcessor> outgoingProcessors = new ArrayList<MessageProcessor>();
    private final OutgoingMessageHolder outgoing;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final String instanceIdHeaderValue;

    public StateMachines(LogProvider logProvider, Monitor monitor, MessageSource source, MessageSender sender, Timeouts timeouts, DelayedDirectExecutor executor, Executor stateMachineExecutor, InstanceId instanceId) {
        this.log = logProvider.getLog(this.getClass());
        this.monitor = monitor;
        this.sender = sender;
        this.executor = executor;
        this.stateMachineExecutor = stateMachineExecutor;
        this.timeouts = timeouts;
        this.instanceIdHeaderValue = instanceId.toString();
        this.outgoing = new OutgoingMessageHolder();
        timeouts.addMessageProcessor(this);
        source.addMessageProcessor(this);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public synchronized void addStateMachine(StateMachine stateMachine) {
        this.stateMachines.put(stateMachine.getMessageType(), stateMachine);
    }

    public synchronized void removeStateMachine(StateMachine stateMachine) {
        this.stateMachines.remove(stateMachine.getMessageType());
    }

    public Iterable<StateMachine> getStateMachines() {
        return this.stateMachines.values();
    }

    @Override
    public void addMessageProcessor(MessageProcessor messageProcessor) {
        this.outgoingProcessors.add(messageProcessor);
    }

    public OutgoingMessageHolder getOutgoing() {
        return this.outgoing;
    }

    @Override
    public boolean process(final Message<? extends MessageType> message) {
        this.stateMachineExecutor.execute(new Runnable(){
            OutgoingMessageHolder temporaryOutgoing;
            {
                this.temporaryOutgoing = new OutgoingMessageHolder();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StateMachines.this.monitor.beganProcessing(message);
                StateMachines.this.lock.writeLock().lock();
                try {
                    Timeouts timeouts = StateMachines.this.timeouts;
                    synchronized (timeouts) {
                        StateMachine stateMachine;
                        block16: {
                            stateMachine = (StateMachine)StateMachines.this.stateMachines.get(message.getMessageType().getClass());
                            if (stateMachine != null) break block16;
                            return;
                        }
                        this.handleMessage(stateMachine, message);
                        LinkedList<Message<? extends MessageType>> toSend = new LinkedList<Message<? extends MessageType>>();
                        try {
                            Message<? extends MessageType> outgoingMessage;
                            while ((outgoingMessage = StateMachines.this.outgoing.nextOutgoingMessage()) != null) {
                                message.copyHeadersTo(outgoingMessage, "conversation-id", "created-by");
                                for (MessageProcessor outgoingProcessor : StateMachines.this.outgoingProcessors) {
                                    try {
                                        if (outgoingProcessor.process(outgoingMessage)) continue;
                                        break;
                                    }
                                    catch (Throwable e) {
                                        StateMachines.this.log.warn("Outgoing message processor threw exception", e);
                                    }
                                }
                                if (outgoingMessage.hasHeader("to")) {
                                    outgoingMessage.setHeader("instance-id", StateMachines.this.instanceIdHeaderValue);
                                    toSend.add(outgoingMessage);
                                    continue;
                                }
                                StateMachine internalStatemachine = (StateMachine)StateMachines.this.stateMachines.get(outgoingMessage.getMessageType().getClass());
                                if (internalStatemachine == null) continue;
                                this.handleMessage(internalStatemachine, outgoingMessage);
                            }
                            if (!toSend.isEmpty()) {
                                StateMachines.this.sender.process(toSend);
                            }
                        }
                        catch (Exception e) {
                            StateMachines.this.log.warn("Error processing message " + message, (Throwable)e);
                        }
                    }
                }
                finally {
                    StateMachines.this.lock.writeLock().unlock();
                }
                StateMachines.this.executor.drain();
                StateMachines.this.monitor.finishedProcessing(message);
            }

            private void handleMessage(StateMachine stateMachine, Message<? extends MessageType> message2) {
                Message<? extends MessageType> next;
                stateMachine.handle(message2, this.temporaryOutgoing);
                while ((next = this.temporaryOutgoing.nextOutgoingMessage()) != null) {
                    StateMachines.this.outgoing.offer(next);
                }
            }
        });
        return true;
    }

    public void addStateTransitionListener(StateTransitionListener stateTransitionListener) {
        for (StateMachine stateMachine : this.stateMachines.values()) {
            stateMachine.addStateTransitionListener(stateTransitionListener);
        }
    }

    public void removeStateTransitionListener(StateTransitionListener stateTransitionListener) {
        for (StateMachine stateMachine : this.stateMachines.values()) {
            stateMachine.removeStateTransitionListener(stateTransitionListener);
        }
    }

    public String toString() {
        ArrayList<String> states = new ArrayList<String>();
        for (StateMachine stateMachine : this.stateMachines.values()) {
            states.add(stateMachine.getState().getClass().getSuperclass().getSimpleName() + ":" + stateMachine.getState().toString());
        }
        return ((Object)states).toString();
    }

    public StateMachine getStateMachine(Class<? extends MessageType> messageType) {
        return this.stateMachines.get(messageType);
    }

    private class OutgoingMessageHolder
    implements MessageHolder {
        private Deque<Message<? extends MessageType>> outgoingMessages = new ArrayDeque<Message<? extends MessageType>>();

        private OutgoingMessageHolder() {
        }

        @Override
        public synchronized void offer(Message<? extends MessageType> message) {
            this.outgoingMessages.addFirst(message);
        }

        public synchronized Message<? extends MessageType> nextOutgoingMessage() {
            return this.outgoingMessages.pollFirst();
        }
    }

    public static interface Monitor {
        public void beganProcessing(Message var1);

        public void finishedProcessing(Message var1);
    }
}

