/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cluster;

import java.util.concurrent.Executor;
import org.neo4j.cluster.DelayedDirectExecutor;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.ProtocolServer;
import org.neo4j.cluster.ProtocolServerFactory;
import org.neo4j.cluster.StateMachines;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageSender;
import org.neo4j.cluster.com.message.MessageSource;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectInputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.ObjectOutputStreamFactory;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorInstanceStore;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AcceptorState;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AtomicBroadcastContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AtomicBroadcastMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.AtomicBroadcastState;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.LearnerState;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerContext;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerMessage;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.ProposerState;
import org.neo4j.cluster.protocol.atomicbroadcast.multipaxos.context.MultiPaxosContext;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterConfiguration;
import org.neo4j.cluster.protocol.cluster.ClusterContext;
import org.neo4j.cluster.protocol.cluster.ClusterMessage;
import org.neo4j.cluster.protocol.cluster.ClusterState;
import org.neo4j.cluster.protocol.election.ClusterLeaveReelectionListener;
import org.neo4j.cluster.protocol.election.Election;
import org.neo4j.cluster.protocol.election.ElectionContext;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.ElectionMessage;
import org.neo4j.cluster.protocol.election.ElectionRole;
import org.neo4j.cluster.protocol.election.ElectionState;
import org.neo4j.cluster.protocol.election.HeartbeatReelectionListener;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatContext;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatIAmAliveProcessor;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatJoinListener;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatLeftListener;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatMessage;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatRefreshProcessor;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatState;
import org.neo4j.cluster.protocol.snapshot.SnapshotContext;
import org.neo4j.cluster.protocol.snapshot.SnapshotMessage;
import org.neo4j.cluster.protocol.snapshot.SnapshotState;
import org.neo4j.cluster.statemachine.StateMachine;
import org.neo4j.cluster.statemachine.StateMachineRules;
import org.neo4j.cluster.timeout.TimeoutStrategy;
import org.neo4j.cluster.timeout.Timeouts;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;

public class MultiPaxosServerFactory
implements ProtocolServerFactory {
    private final ClusterConfiguration initialConfig;
    private final LogProvider logging;
    private StateMachines.Monitor stateMachinesMonitor;

    public MultiPaxosServerFactory(ClusterConfiguration initialConfig, LogProvider logging, StateMachines.Monitor stateMachinesMonitor) {
        this.initialConfig = initialConfig;
        this.logging = logging;
        this.stateMachinesMonitor = stateMachinesMonitor;
    }

    @Override
    public ProtocolServer newProtocolServer(InstanceId me, TimeoutStrategy timeoutStrategy, MessageSource input, MessageSender output, AcceptorInstanceStore acceptorInstanceStore, ElectionCredentialsProvider electionCredentialsProvider, Executor stateMachineExecutor, ObjectInputStreamFactory objectInputStreamFactory, ObjectOutputStreamFactory objectOutputStreamFactory, Config config) {
        DelayedDirectExecutor executor = new DelayedDirectExecutor(this.logging);
        Timeouts timeouts = new Timeouts(timeoutStrategy);
        MultiPaxosContext context = new MultiPaxosContext(me, Iterables.iterable((Object[])new ElectionRole[]{new ElectionRole("coordinator")}), new ClusterConfiguration(this.initialConfig.getName(), this.logging, this.initialConfig.getMemberURIs()), executor, this.logging, objectInputStreamFactory, objectOutputStreamFactory, acceptorInstanceStore, timeouts, electionCredentialsProvider, config);
        SnapshotContext snapshotContext = new SnapshotContext(context.getClusterContext(), context.getLearnerContext());
        return this.newProtocolServer(me, input, output, stateMachineExecutor, executor, timeouts, context, snapshotContext);
    }

    public ProtocolServer newProtocolServer(InstanceId me, MessageSource input, MessageSender output, Executor stateMachineExecutor, DelayedDirectExecutor executor, Timeouts timeouts, MultiPaxosContext context, SnapshotContext snapshotContext) {
        return this.constructSupportingInfrastructureFor(me, input, output, executor, timeouts, stateMachineExecutor, context, new StateMachine[]{new StateMachine<AtomicBroadcastContext, AtomicBroadcastMessage>(context.getAtomicBroadcastContext(), AtomicBroadcastMessage.class, AtomicBroadcastState.start, this.logging), new StateMachine<AcceptorContext, AcceptorMessage>(context.getAcceptorContext(), AcceptorMessage.class, AcceptorState.start, this.logging), new StateMachine<ProposerContext, ProposerMessage>(context.getProposerContext(), ProposerMessage.class, ProposerState.start, this.logging), new StateMachine<LearnerContext, LearnerMessage>(context.getLearnerContext(), LearnerMessage.class, LearnerState.start, this.logging), new StateMachine<HeartbeatContext, HeartbeatMessage>(context.getHeartbeatContext(), HeartbeatMessage.class, HeartbeatState.start, this.logging), new StateMachine<ElectionContext, ElectionMessage>(context.getElectionContext(), ElectionMessage.class, ElectionState.start, this.logging), new StateMachine<SnapshotContext, SnapshotMessage>(snapshotContext, SnapshotMessage.class, SnapshotState.start, this.logging), new StateMachine<ClusterContext, ClusterMessage>(context.getClusterContext(), ClusterMessage.class, ClusterState.start, this.logging)});
    }

    public ProtocolServer constructSupportingInfrastructureFor(InstanceId me, MessageSource input, MessageSender output, DelayedDirectExecutor executor, Timeouts timeouts, Executor stateMachineExecutor, MultiPaxosContext context, StateMachine[] machines) {
        StateMachines stateMachines = new StateMachines(this.logging, this.stateMachinesMonitor, input, output, timeouts, executor, stateMachineExecutor, me);
        for (StateMachine machine : machines) {
            stateMachines.addStateMachine(machine);
        }
        ProtocolServer server = new ProtocolServer(me, stateMachines, this.logging);
        server.addBindingListener(me1 -> context.getClusterContext().setBoundAt(me1));
        stateMachines.addMessageProcessor(new HeartbeatRefreshProcessor(stateMachines.getOutgoing(), context.getClusterContext()));
        input.addMessageProcessor(new HeartbeatIAmAliveProcessor(stateMachines.getOutgoing(), context.getClusterContext()));
        Cluster cluster = server.newClient(Cluster.class);
        cluster.addClusterListener(new HeartbeatJoinListener(stateMachines.getOutgoing()));
        cluster.addClusterListener(new HeartbeatLeftListener(context.getHeartbeatContext(), this.logging));
        context.getHeartbeatContext().addHeartbeatListener(new HeartbeatReelectionListener(server.newClient(Election.class), this.logging));
        context.getClusterContext().addClusterListener(new ClusterLeaveReelectionListener(server.newClient(Election.class), this.logging));
        StateMachineRules rules = new StateMachineRules(stateMachines.getOutgoing()).rule(ClusterState.start, ClusterMessage.create, ClusterState.entered, Message.internal(AtomicBroadcastMessage.entered), Message.internal(ProposerMessage.join), Message.internal(AcceptorMessage.join), Message.internal(LearnerMessage.join), Message.internal(HeartbeatMessage.join), Message.internal(ElectionMessage.created), Message.internal(SnapshotMessage.join)).rule(ClusterState.discovery, ClusterMessage.configurationResponse, ClusterState.joining, Message.internal(AcceptorMessage.join), Message.internal(LearnerMessage.join), Message.internal(AtomicBroadcastMessage.join)).rule(ClusterState.discovery, ClusterMessage.configurationResponse, ClusterState.entered, Message.internal(AtomicBroadcastMessage.entered), Message.internal(ProposerMessage.join), Message.internal(AcceptorMessage.join), Message.internal(LearnerMessage.join), Message.internal(HeartbeatMessage.join), Message.internal(ElectionMessage.join), Message.internal(SnapshotMessage.join)).rule(ClusterState.joining, ClusterMessage.configurationChanged, ClusterState.entered, Message.internal(AtomicBroadcastMessage.entered), Message.internal(ProposerMessage.join), Message.internal(AcceptorMessage.join), Message.internal(LearnerMessage.join), Message.internal(HeartbeatMessage.join), Message.internal(ElectionMessage.join), Message.internal(SnapshotMessage.join)).rule(ClusterState.joining, ClusterMessage.joinFailure, ClusterState.start, Message.internal(AtomicBroadcastMessage.leave), Message.internal(AcceptorMessage.leave), Message.internal(LearnerMessage.leave), Message.internal(ProposerMessage.leave)).rule(ClusterState.entered, ClusterMessage.leave, ClusterState.start, Message.internal(AtomicBroadcastMessage.leave), Message.internal(AcceptorMessage.leave), Message.internal(LearnerMessage.leave), Message.internal(HeartbeatMessage.leave), Message.internal(SnapshotMessage.leave), Message.internal(ElectionMessage.leave), Message.internal(ProposerMessage.leave)).rule(ClusterState.entered, ClusterMessage.leave, ClusterState.start, Message.internal(AtomicBroadcastMessage.leave), Message.internal(AcceptorMessage.leave), Message.internal(LearnerMessage.leave), Message.internal(HeartbeatMessage.leave), Message.internal(ElectionMessage.leave), Message.internal(SnapshotMessage.leave), Message.internal(ProposerMessage.leave)).rule(ClusterState.leaving, ClusterMessage.configurationChanged, ClusterState.start, Message.internal(AtomicBroadcastMessage.leave), Message.internal(AcceptorMessage.leave), Message.internal(LearnerMessage.leave), Message.internal(HeartbeatMessage.leave), Message.internal(ElectionMessage.leave), Message.internal(SnapshotMessage.leave), Message.internal(ProposerMessage.leave)).rule(ClusterState.leaving, ClusterMessage.leaveTimedout, ClusterState.start, Message.internal(AtomicBroadcastMessage.leave), Message.internal(AcceptorMessage.leave), Message.internal(LearnerMessage.leave), Message.internal(HeartbeatMessage.leave), Message.internal(ElectionMessage.leave), Message.internal(SnapshotMessage.leave), Message.internal(ProposerMessage.leave));
        stateMachines.addStateTransitionListener(rules);
        return server;
    }
}

