/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.capabilities;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.exceptions.UnsatisfiedDependencyException;

final class CapabilityProviderDependencies {
    private final Map<Class<?>, Supplier<?>> dependencies = new HashMap();

    CapabilityProviderDependencies() {
    }

    <T> void register(Class<T> cls, Supplier<T> supplier) {
        Supplier<T> old = this.dependencies.putIfAbsent(cls, supplier);
        if (old != null) {
            throw new UnsupportedOperationException(String.format("'%s' is already registered.", cls.getName()));
        }
    }

    <T> T get(Class<T> cls) {
        Supplier<?> supplier = this.dependencies.get(cls);
        if (supplier == null) {
            throw new UnsatisfiedDependencyException(cls);
        }
        return (T)supplier.get();
    }
}

