/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server;

import java.io.IOException;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.ServerHelper;

final class ServerHolder
extends Thread {
    private static AssertionError allocation;
    private static NeoServer server;
    private static CommunityServerBuilder builder;

    static synchronized NeoServer allocate() throws IOException {
        if (allocation != null) {
            throw allocation;
        }
        if (server == null) {
            server = ServerHolder.startServer();
        }
        allocation = new AssertionError((Object)"The server was allocated from here but not released properly");
        return server;
    }

    static synchronized void release(NeoServer server) {
        if (server == null) {
            return;
        }
        if (server != ServerHolder.server) {
            throw new AssertionError((Object)"trying to suspend a server not allocated from here");
        }
        if (allocation == null) {
            throw new AssertionError((Object)"releasing the server although it is not allocated");
        }
        allocation = null;
    }

    static synchronized void ensureNotRunning() {
        if (allocation != null) {
            throw allocation;
        }
        ServerHolder.shutdown();
    }

    static synchronized void setServerBuilderProperty(String key, String value) {
        ServerHolder.initBuilder();
        builder = builder.withProperty(key, value);
    }

    private static NeoServer startServer() throws IOException {
        ServerHolder.initBuilder();
        return ServerHelper.createNonPersistentServer(builder);
    }

    private static synchronized void shutdown() {
        allocation = null;
        try {
            if (server != null) {
                server.stop();
            }
        }
        finally {
            builder = null;
            server = null;
        }
    }

    private static void initBuilder() {
        if (builder == null) {
            builder = CommunityServerBuilder.server();
        }
    }

    @Override
    public void run() {
        ServerHolder.shutdown();
    }

    private ServerHolder() {
        super(ServerHolder.class.getName());
    }

    static {
        Runtime.getRuntime().addShutdownHook(new ServerHolder());
    }
}

