/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.scripting.javascript;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.scripting.javascript.WhiteListClassShutter;

public class TestWhiteListClassShutter {
    @Test
    public void shouldAllowWhiteListedClasses() throws Exception {
        HashSet<String> whiteList = new HashSet<String>();
        whiteList.add(this.getClass().getName());
        WhiteListClassShutter shutter = new WhiteListClassShutter(whiteList);
        boolean visible = shutter.visibleToScripts(this.getClass().getName());
        Assert.assertThat((Object)visible, (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldDisallowUnlistedClasses() throws Exception {
        WhiteListClassShutter shutter = new WhiteListClassShutter(new HashSet());
        boolean visible = shutter.visibleToScripts(this.getClass().getName());
        Assert.assertThat((Object)visible, (Matcher)Is.is((Object)false));
    }
}

