/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappedDatabase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.web.DatabaseMetadataService;
import org.neo4j.test.TestGraphDatabaseFactory;

public class DatabaseMetadataServiceTest {
    private GraphDatabaseFacade db;
    private long relId;

    @Before
    public void setup() {
        this.db = (GraphDatabaseFacade)new TestGraphDatabaseFactory().newImpermanentDatabase();
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            node.createRelationshipTo(this.db.createNode(), RelationshipType.withName((String)"a"));
            node.createRelationshipTo(this.db.createNode(), RelationshipType.withName((String)"b"));
            this.relId = node.createRelationshipTo(this.db.createNode(), RelationshipType.withName((String)"c")).getId();
            tx.success();
        }
    }

    @Test
    public void shouldAdvertiseRelationshipTypesThatCurrentlyExistInTheDatabase() throws Throwable {
        try (Transaction tx = this.db.beginTx();){
            this.db.getRelationshipById(this.relId).delete();
            tx.success();
        }
        WrappedDatabase database = new WrappedDatabase(this.db);
        DatabaseMetadataService service = new DatabaseMetadataService((Database)database);
        try (Transaction tx = this.db.beginTx();){
            Response response = service.getRelationshipTypes(false);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            List jsonList = JsonHelper.jsonToList((String)response.getEntity().toString());
            Assert.assertEquals((long)3L, (long)jsonList.size());
        }
        database.stop();
    }

    @Test
    public void shouldAdvertiseRelationshipTypesThatCurrentlyInUseInTheDatabase() throws Throwable {
        try (Transaction tx = this.db.beginTx();){
            this.db.getRelationshipById(this.relId).delete();
            tx.success();
        }
        WrappedDatabase database = new WrappedDatabase(this.db);
        DatabaseMetadataService service = new DatabaseMetadataService((Database)database);
        try (Transaction tx = this.db.beginTx();){
            Response response = service.getRelationshipTypes(true);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            List jsonList = JsonHelper.jsonToList((String)response.getEntity().toString());
            Assert.assertEquals((long)2L, (long)jsonList.size());
        }
        database.stop();
    }
}

