/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.repr.util.RFC1123;

public class RFC1123Test {
    private final Calendar calendar = Calendar.getInstance(RFC1123.GMT, Locale.US);

    @Test
    public void shouldParseRFC1123() throws Exception {
        String input = "Mon, 15 Aug 2005 15:52:01 +0000";
        Date result = RFC1123.parseTimestamp((String)input);
        this.calendar.setTime(result);
        Assert.assertEquals((long)2L, (long)this.calendar.get(7));
        Assert.assertEquals((long)15L, (long)this.calendar.get(5));
        Assert.assertEquals((long)7L, (long)this.calendar.get(2));
        Assert.assertEquals((long)2005L, (long)this.calendar.get(1));
        Assert.assertEquals((long)15L, (long)this.calendar.get(11));
        Assert.assertEquals((long)52L, (long)this.calendar.get(12));
        Assert.assertEquals((long)1L, (long)this.calendar.get(13));
    }

    @Test
    public void shouldFormatRFC1123() throws Exception {
        String input = "Mon, 15 Aug 2005 15:52:01 +0000";
        String output = RFC1123.formatDate((Date)RFC1123.parseTimestamp((String)input));
        Assert.assertEquals((Object)input, (Object)output);
    }

    @Test
    public void shouldReturnSameInstanceInSameThread() throws Exception {
        RFC1123 instance2;
        RFC1123 instance = RFC1123.instance();
        Assert.assertTrue((String)"Expected to get same instance from second call to RFC1123.instance() in same thread", (instance == (instance2 = RFC1123.instance()) ? 1 : 0) != 0);
    }
}

