/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ServerListRepresentation;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.rest.repr.formats.JsonFormat;

public class JsonFormatTest {
    private OutputFormat json;

    @Before
    public void createOutputFormat() throws Exception {
        this.json = new OutputFormat((RepresentationFormat)new JsonFormat(), new URI("http://localhost/"), null);
    }

    @Test
    public void canFormatString() throws Exception {
        String entity = this.json.assemble((Representation)ValueRepresentation.string((String)"expected value"));
        Assert.assertEquals((Object)entity, (Object)"\"expected value\"");
    }

    @Test
    public void canFormatListOfStrings() throws Exception {
        String entity = this.json.assemble((Representation)ListRepresentation.strings((String[])new String[]{"hello", "world"}));
        String expectedString = JsonHelper.createJsonFrom(Arrays.asList("hello", "world"));
        Assert.assertEquals((Object)expectedString, (Object)entity);
    }

    @Test
    public void canFormatInteger() throws Exception {
        String entity = this.json.assemble((Representation)ValueRepresentation.number((int)10));
        Assert.assertEquals((Object)"10", (Object)entity);
    }

    @Test
    public void canFormatEmptyObject() throws Exception {
        String entity = this.json.assemble((Representation)new MappingRepresentation("empty"){

            protected void serialize(MappingSerializer serializer) {
            }
        });
        Assert.assertEquals((Object)JsonHelper.createJsonFrom(Collections.emptyMap()), (Object)entity);
    }

    @Test
    public void canFormatObjectWithStringField() throws Exception {
        String entity = this.json.assemble((Representation)new MappingRepresentation("string"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putString("key", "expected string");
            }
        });
        Assert.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("key", "expected string")), (Object)entity);
    }

    @Test
    public void canFormatObjectWithUriField() throws Exception {
        String entity = this.json.assemble((Representation)new MappingRepresentation("uri"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putUri("URL", "subpath");
            }
        });
        Assert.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("URL", "http://localhost/subpath")), (Object)entity);
    }

    @Test
    public void canFormatObjectWithNestedObject() throws Exception {
        String entity = this.json.assemble((Representation)new MappingRepresentation("nesting"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putMapping("nested", new MappingRepresentation("data"){

                    protected void serialize(MappingSerializer nested) {
                        nested.putString("data", "expected data");
                    }
                });
            }
        });
        Assert.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("nested", Collections.singletonMap("data", "expected data"))), (Object)entity);
    }

    @Test
    public void canFormatNestedMapsAndLists() throws Exception {
        String entity = this.json.assemble((Representation)new MappingRepresentation("test"){

            protected void serialize(MappingSerializer serializer) {
                ArrayList<1> maps = new ArrayList<1>();
                maps.add(new MappingRepresentation("map"){

                    protected void serialize(MappingSerializer serializer) {
                        serializer.putString("foo", "bar");
                    }
                });
                serializer.putList("foo", (ListRepresentation)new ServerListRepresentation(RepresentationType.MAP, maps));
            }
        });
        Assert.assertEquals((Object)"bar", ((Map)((List)JsonHelper.jsonToMap((String)entity).get("foo")).get(0)).get("foo"));
    }
}

