/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;
import org.neo4j.server.rest.repr.RepresentationTestBase;
import org.neo4j.test.Property;
import org.neo4j.test.mocking.GraphMock;
import org.neo4j.test.mocking.Link;
import org.neo4j.test.mocking.Properties;

public class PathRepresentationTest {
    @Test
    public void shouldHaveLength() throws BadInputException {
        Assert.assertNotNull((Object)this.pathrep().length());
    }

    @Test
    public void shouldHaveStartNodeLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", this.pathrep().startNode());
    }

    @Test
    public void shouldHaveEndNodeLink() throws BadInputException {
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", this.pathrep().endNode());
    }

    @Test
    public void shouldHaveNodeList() throws BadInputException {
        Assert.assertNotNull((Object)this.pathrep().nodes());
    }

    @Test
    public void shouldHaveRelationshipList() throws BadInputException {
        Assert.assertNotNull((Object)this.pathrep().relationships());
    }

    @Test
    public void shouldHaveDirectionList() throws BadInputException {
        Assert.assertNotNull((Object)this.pathrep().directions());
    }

    @Test
    public void shouldSerialiseToMap() {
        Map<String, Object> repr = RepresentationTestAccess.serialize(this.pathrep());
        Assert.assertNotNull(repr);
        PathRepresentationTest.verifySerialisation(repr);
    }

    private PathRepresentation<Path> pathrep() {
        Node a = GraphMock.node((long)0L, (Properties)Properties.properties((Property[])new Property[0]), (String[])new String[0]);
        Node b = GraphMock.node((long)1L, (Properties)Properties.properties((Property[])new Property[0]), (String[])new String[0]);
        Node c = GraphMock.node((long)2L, (Properties)Properties.properties((Property[])new Property[0]), (String[])new String[0]);
        Node d = GraphMock.node((long)3L, (Properties)Properties.properties((Property[])new Property[0]), (String[])new String[0]);
        Relationship ab = GraphMock.relationship((long)17L, (Node)a, (String)"LOVES", (Node)b, (Property[])new Property[0]);
        Relationship cb = GraphMock.relationship((long)18L, (Node)c, (String)"HATES", (Node)b, (Property[])new Property[0]);
        Relationship cd = GraphMock.relationship((long)19L, (Node)c, (String)"KNOWS", (Node)d, (Property[])new Property[0]);
        return new PathRepresentation(GraphMock.path((Node)a, (Link[])new Link[]{Link.link((Relationship)ab, (Node)b), Link.link((Relationship)cb, (Node)c), Link.link((Relationship)cd, (Node)d)}));
    }

    public static void verifySerialisation(Map<String, Object> pathrep) {
        Assert.assertNotNull((Object)pathrep.get("length"));
        int length = Integer.parseInt(pathrep.get("length").toString());
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", pathrep.get("start").toString());
        RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", pathrep.get("end").toString());
        Object nodes = pathrep.get("nodes");
        Assert.assertTrue((boolean)(nodes instanceof List));
        List nodeList = (List)nodes;
        Assert.assertEquals((long)(length + 1), (long)nodeList.size());
        for (Object node : nodeList) {
            RepresentationTestBase.assertUriMatches("http://.*/node/[0-9]+", node.toString());
        }
        Object rels = pathrep.get("relationships");
        Assert.assertTrue((boolean)(rels instanceof List));
        List relList = (List)rels;
        Assert.assertEquals((long)length, (long)relList.size());
        for (Object rel : relList) {
            RepresentationTestBase.assertUriMatches("http://.*/relationship/[0-9]+", rel.toString());
        }
        Object directions = pathrep.get("directions");
        Assert.assertTrue((boolean)(directions instanceof List));
        List directionList = (List)directions;
        Assert.assertEquals((long)length, (long)directionList.size());
        Assert.assertEquals((Object)"->", (Object)directionList.get(0).toString());
        Assert.assertEquals((Object)"<-", (Object)directionList.get(1).toString());
        Assert.assertEquals((Object)"->", (Object)directionList.get(2).toString());
    }
}

