/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalDocTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.formats.CompactJsonFormat;

public class RetrieveNodeDocIT
extends AbstractRestFunctionalDocTestBase {
    private URI nodeUri;
    private static FunctionalTestHelper functionalTestHelper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(RetrieveNodeDocIT.server());
    }

    @Before
    public void cleanTheDatabaseAndInitialiseTheNodeUri() throws Exception {
        this.nodeUri = new URI(functionalTestHelper.nodeUri() + "/" + new GraphDbHelper(RetrieveNodeDocIT.server().getDatabase()).createNode(new Label[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldParameteriseUrisInNodeRepresentationWithHostHeaderValue() throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(this.nodeUri);
            httpget.setHeader("Accept", "application/json");
            httpget.setHeader("Host", "dummy.neo4j.org");
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            String entityBody = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
            Assert.assertThat((Object)entityBody, (Matcher)Matchers.containsString((String)"http://dummy.neo4j.org/db/data/node/"));
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldParameteriseUrisInNodeRepresentationWithoutHostHeaderUsingRequestUri() throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(this.nodeUri);
            httpget.setHeader("Accept", "application/json");
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            String entityBody = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
            Assert.assertThat((Object)entityBody, (Matcher)Matchers.containsString((String)this.nodeUri.toString()));
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    @Documented(value="Get node.\n\nNote that the response contains URI/templates for the available\noperations for getting properties and relationships.")
    @Test
    public void shouldGet200WhenRetrievingNode() throws Exception {
        String uri = this.nodeUri.toString();
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(uri);
    }

    @Documented(value="Get node -- compact.\n\nSpecifying the subformat in the requests media type yields a more compact\nJSON response without metadata and templates.")
    @Test
    public void shouldGet200WhenRetrievingNodeCompact() {
        String uri = this.nodeUri.toString();
        RESTDocsGenerator.ResponseEntity entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedType(CompactJsonFormat.MEDIA_TYPE).expectedStatus(200).get(uri);
        Assert.assertTrue((boolean)entity.entity().contains("self"));
    }

    @Test
    public void shouldGetContentLengthHeaderWhenRetrievingNode() throws Exception {
        JaxRsResponse response = this.retrieveNodeFromService(this.nodeUri.toString());
        Assert.assertNotNull((Object)response.getHeaders().get((Object)"Content-Length"));
        response.close();
    }

    @Test
    public void shouldHaveJsonMediaTypeOnResponse() {
        JaxRsResponse response = this.retrieveNodeFromService(this.nodeUri.toString());
        Assert.assertThat((Object)response.getType().toString(), (Matcher)Matchers.containsString((String)"application/json"));
        response.close();
    }

    @Test
    public void shouldHaveJsonDataInResponse() throws Exception {
        JaxRsResponse response = this.retrieveNodeFromService(this.nodeUri.toString());
        Map map = JsonHelper.jsonToMap((String)response.getEntity());
        Assert.assertTrue((boolean)map.containsKey("self"));
        response.close();
    }

    @Documented(value="Get non-existent node.")
    @Test
    public void shouldGet404WhenRetrievingNonExistentNode() throws Exception {
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(404).get(this.nodeUri + "00000");
    }

    private JaxRsResponse retrieveNodeFromService(String uri) {
        return RestRequest.req().get(uri);
    }
}

