/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.UniqueStrings;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.domain.URIHelper;

public class IndexRelationshipDocIT
extends AbstractRestFunctionalTestBase {
    private static FunctionalTestHelper functionalTestHelper;
    private static GraphDbHelper helper;
    private static RestRequest request;
    private final Factory<String> indexes = UniqueStrings.withPrefix("index");

    @BeforeClass
    public static void setupServer() {
        functionalTestHelper = new FunctionalTestHelper(IndexRelationshipDocIT.server());
        helper = functionalTestHelper.getGraphDbHelper();
        request = RestRequest.req();
    }

    @Test
    public void shouldCreateANamedRelationshipIndexAndAddToIt() throws JsonParseException {
        String indexName = (String)this.indexes.newInstance();
        int expectedIndexes = helper.getRelationshipIndexes().length + 1;
        HashMap<String, String> indexSpecification = new HashMap<String, String>();
        indexSpecification.put("name", indexName);
        JaxRsResponse response = this.httpPostIndexRelationshipRoot(JsonHelper.createJsonFrom(indexSpecification));
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull(((List)response.getHeaders().get((Object)"Location")).get(0));
        Assert.assertEquals((long)expectedIndexes, (long)helper.getRelationshipIndexes().length);
        Assert.assertNotNull(helper.createRelationshipIndex(indexName));
        String key = "key";
        String value = "value";
        String relationshipType = "related-to";
        long relationshipId = helper.createRelationship(relationshipType);
        response = this.httpPostIndexRelationshipNameKeyValue(indexName, relationshipId, key, value);
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        String indexUri = (String)((List)response.getHeaders().get((Object)"Location")).get(0);
        Assert.assertNotNull((Object)indexUri);
        Assert.assertEquals(Arrays.asList(relationshipId), helper.getIndexedRelationships(indexName, key, value));
        response = this.httpGet(indexUri);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String discovredEntity = response.getEntity();
        Map map = JsonHelper.jsonToMap((String)discovredEntity);
        Assert.assertNotNull(map.get("self"));
    }

    @Test
    public void shouldGet404WhenRequestingIndexUriWhichDoesntExist() {
        String key = "key3";
        String value = "value";
        String indexName = (String)this.indexes.newInstance();
        String indexUri = functionalTestHelper.relationshipIndexUri() + indexName + "/" + key + "/" + value;
        JaxRsResponse response = this.httpGet(indexUri);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGet404WhenDeletingNonExtistentIndex() {
        String indexName = (String)this.indexes.newInstance();
        String indexUri = functionalTestHelper.relationshipIndexUri() + indexName;
        JaxRsResponse response = request.delete(indexUri);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGet200AndArrayOfRelationshipRepsWhenGettingFromIndex() throws JsonParseException {
        long startNode = helper.createNode(new Label[0]);
        long endNode = helper.createNode(new Label[0]);
        String key = "key_get";
        String value = "value";
        String relationshipName1 = "related-to";
        String relationshipName2 = "dislikes";
        String jsonString = this.jsonRelationshipCreationSpecification("related-to", endNode, "key_get", "value");
        JaxRsResponse createRelationshipResponse = this.httpPostCreateRelationship(startNode, jsonString);
        Assert.assertEquals((long)201L, (long)createRelationshipResponse.getStatus());
        String relationshipLocation1 = createRelationshipResponse.getLocation().toString();
        jsonString = this.jsonRelationshipCreationSpecification("dislikes", endNode, "key_get", "value");
        createRelationshipResponse = this.httpPostCreateRelationship(startNode, jsonString);
        Assert.assertEquals((long)201L, (long)createRelationshipResponse.getStatus());
        String relationshipLocation2 = (String)((List)createRelationshipResponse.getHeaders().get((Object)"Location")).get(0);
        String indexName = (String)this.indexes.newInstance();
        JaxRsResponse indexCreationResponse = this.httpPostIndexRelationshipRoot("{\"name\":\"" + indexName + "\"}");
        Assert.assertEquals((long)201L, (long)indexCreationResponse.getStatus());
        JaxRsResponse indexedRelationshipResponse = this.httpPostIndexRelationshipNameKeyValue(indexName, functionalTestHelper.getRelationshipIdFromUri(relationshipLocation1), "key_get", "value");
        String indexLocation1 = (String)((List)indexedRelationshipResponse.getHeaders().get((Object)"Location")).get(0);
        indexedRelationshipResponse = this.httpPostIndexRelationshipNameKeyValue(indexName, functionalTestHelper.getRelationshipIdFromUri(relationshipLocation2), "key_get", "value");
        String indexLocation2 = (String)((List)indexedRelationshipResponse.getHeaders().get((Object)"Location")).get(0);
        HashMap<String, String> uriToName = new HashMap<String, String>();
        uriToName.put(indexLocation1.toString(), "related-to");
        uriToName.put(indexLocation2.toString(), "dislikes");
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.indexRelationshipUri(indexName, "key_get", "value"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Collection items = (Collection)JsonHelper.readJson((String)response.getEntity());
        int counter = 0;
        for (Object item : items) {
            Map map = (Map)item;
            Assert.assertNotNull(map.get("self"));
            String indexedUri = (String)map.get("indexed");
            Assert.assertEquals(uriToName.get(indexedUri), map.get("type"));
            ++counter;
        }
        Assert.assertEquals((long)2L, (long)counter);
        response.close();
    }

    @Test
    public void shouldGet200WhenGettingRelationshipFromIndexWithNoHits() {
        String indexName = (String)this.indexes.newInstance();
        helper.createRelationshipIndex(indexName);
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.indexRelationshipUri(indexName, "non-existent-key", "non-existent-value"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void shouldGet200WhenQueryingIndex() {
        String indexName = (String)this.indexes.newInstance();
        String key = "bobsKey";
        String value = "bobsValue";
        long relationship = helper.createRelationship("TYPE");
        helper.addRelationshipToIndex(indexName, key, value, relationship);
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.indexRelationshipUri(indexName) + "?query=" + key + ":" + value);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void shouldBeAbleToRemoveIndexing() {
        String key1 = "kvkey1";
        String key2 = "kvkey2";
        String value1 = "value1";
        String value2 = "value2";
        String indexName = (String)this.indexes.newInstance();
        long relationship = helper.createRelationship("some type");
        helper.setRelationshipProperties(relationship, MapUtil.map((Object[])new Object[]{key1, value1, key1, value2, key2, value1, key2, value2}));
        helper.addRelationshipToIndex(indexName, key1, value1, relationship);
        helper.addRelationshipToIndex(indexName, key1, value2, relationship);
        helper.addRelationshipToIndex(indexName, key2, value1, relationship);
        helper.addRelationshipToIndex(indexName, key2, value2, relationship);
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key1, value1).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key1, value2).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key2, value1).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key2, value2).size());
        JaxRsResponse response = RestRequest.req().delete(functionalTestHelper.relationshipIndexUri() + indexName + "/" + key1 + "/" + value1 + "/" + relationship);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key1, value1).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key1, value2).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key2, value1).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key2, value2).size());
        response = RestRequest.req().delete(functionalTestHelper.relationshipIndexUri() + indexName + "/" + key2 + "/" + relationship);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key1, value1).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedRelationships(indexName, key1, value2).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key2, value1).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key2, value2).size());
        response = RestRequest.req().delete(functionalTestHelper.relationshipIndexUri() + indexName + "/" + relationship);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key1, value1).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key1, value2).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key2, value1).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedRelationships(indexName, key2, value2).size());
        response = RestRequest.req().delete(functionalTestHelper.indexRelationshipUri(indexName));
        Assert.assertEquals((long)204L, (long)response.getStatus());
        Assert.assertFalse((boolean)Arrays.asList(helper.getRelationshipIndexes()).contains(indexName));
    }

    @Test
    public void shouldBeAbleToIndexValuesContainingSpaces() throws Exception {
        long startNodeId = helper.createNode(new Label[0]);
        long endNodeId = helper.createNode(new Label[0]);
        String relationshiptype = "tested-together";
        long relationshipId = helper.createRelationship("tested-together", startNodeId, endNodeId);
        String key = "key";
        String value = "value with   spaces  in it";
        String indexName = (String)this.indexes.newInstance();
        helper.createRelationshipIndex(indexName);
        JaxRsResponse response = this.httpPostIndexRelationshipNameKeyValue(indexName, relationshipId, "key", "value with   spaces  in it");
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        URI location = response.getLocation();
        response.close();
        response = this.httpGetIndexRelationshipNameKeyValue(indexName, "key", URIHelper.encode((String)"value with   spaces  in it"));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        String responseEntity = response.getEntity();
        Collection hits = (Collection)JsonHelper.readJson((String)responseEntity);
        Assert.assertEquals((long)1L, (long)hits.size());
        response.close();
        FunctionalTestHelper.CLIENT.resource(location).delete();
        response = this.httpGetIndexRelationshipNameKeyValue(indexName, "key", URIHelper.encode((String)"value with   spaces  in it"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        responseEntity = response.getEntity();
        hits = (Collection)JsonHelper.readJson((String)responseEntity);
        Assert.assertEquals((long)0L, (long)hits.size());
        response.close();
    }

    @Test
    public void shouldRespondWith400WhenSendingCorruptJson() throws Exception {
        String indexName = (String)this.indexes.newInstance();
        helper.createRelationshipIndex(indexName);
        String corruptJson = "{[}";
        JaxRsResponse response = RestRequest.req().post(functionalTestHelper.indexRelationshipUri(indexName), "{[}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Documented(value="Get or create unique relationship (create).\n\nCreate a unique relationship in an index.\nIf a relationship matching the given key and value already exists in the index, it will be returned.\nIf not, a new relationship will be created.\n\nNOTE: The type and direction of the relationship is not regarded when determining uniqueness.")
    @Test
    public void get_or_create_relationship() throws Exception {
        String index = (String)this.indexes.newInstance();
        String type = "knowledge";
        String key = "name";
        String value = "Tobias";
        helper.createRelationshipIndex(index);
        long start = helper.createNode(new Label[0]);
        long end = helper.createNode(new Label[0]);
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(201).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\":\"Tobias\", \"start\": \"" + functionalTestHelper.nodeUri(start) + "\", \"end\": \"" + functionalTestHelper.nodeUri(end) + "\", \"type\": \"" + "knowledge" + "\"}").post(functionalTestHelper.relationshipIndexUri() + index + "/?uniqueness=get_or_create");
    }

    @Documented(value="Get or create unique relationship (existing).\n\nHere, in case\nof an already existing relationship, the sent data is ignored and the\nexisting relationship returned.")
    @Test
    public void get_or_create_unique_relationship_existing() throws Exception {
        String index = (String)this.indexes.newInstance();
        String key = "name";
        String value = "Peter";
        GraphDatabaseService graphdb = this.graphdb();
        helper.createRelationshipIndex(index);
        try (Transaction tx = graphdb.beginTx();){
            Node node1 = graphdb.createNode();
            Node node2 = graphdb.createNode();
            Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelationshipTypes.KNOWS);
            graphdb.index().forRelationships(index).add((PropertyContainer)rel, "name", (Object)"Peter");
            tx.success();
        }
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"start\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"end\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"type\":\"" + (Object)((Object)MyRelationshipTypes.KNOWS) + "\"}").post(functionalTestHelper.relationshipIndexUri() + index + "?uniqueness=get_or_create");
    }

    @Documented(value="Create a unique relationship or return fail (create).\n\nHere, in case\nof an already existing relationship, an error should be returned. In this\nexample, no existing relationship is found and a new relationship is created.")
    @Test
    public void create_a_unique_relationship_or_return_fail___create() throws Exception {
        String index = (String)this.indexes.newInstance();
        String key = "name";
        String value = "Tobias";
        helper.createRelationshipIndex(index);
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(201).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Tobias\", \"start\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"end\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"type\":\"" + (Object)((Object)MyRelationshipTypes.KNOWS) + "\"}").post(functionalTestHelper.relationshipIndexUri() + index + "?uniqueness=create_or_fail");
        MultivaluedMap<String, String> headers = response.response().getHeaders();
        Map result = JsonHelper.jsonToMap((String)response.entity());
        Assert.assertEquals(result.get("indexed"), (Object)headers.getFirst((Object)"Location"));
    }

    @Documented(value="Create a unique relationship or return fail (fail).\n\nHere, in case\nof an already existing relationship, an error should be returned. In this\nexample, an existing relationship is found and an error is returned.")
    @Test
    public void create_a_unique_relationship_or_return_fail___fail() throws Exception {
        String index = (String)this.indexes.newInstance();
        String key = "name";
        String value = "Peter";
        GraphDatabaseService graphdb = this.graphdb();
        helper.createRelationshipIndex(index);
        try (Transaction tx = graphdb.beginTx();){
            Node node1 = graphdb.createNode();
            Node node2 = graphdb.createNode();
            Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelationshipTypes.KNOWS);
            graphdb.index().forRelationships(index).add((PropertyContainer)rel, "name", (Object)"Peter");
            tx.success();
        }
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(409).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"start\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"end\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"type\":\"" + (Object)((Object)MyRelationshipTypes.KNOWS) + "\"}").post(functionalTestHelper.relationshipIndexUri() + index + "?uniqueness=create_or_fail");
    }

    @Documented(value="Add an existing relationship to a unique index (not indexed).\n\nIf a relationship matching the given key and value already exists in the index, it will be returned.\nIf not, an `HTTP 409` (conflict) status will be returned in this case, as we are using `create_or_fail`.\n\nIt's possible to use `get_or_create` uniqueness as well.\n\nNOTE: The type and direction of the relationship is not regarded when determining uniqueness.")
    @Test
    public void put_relationship_or_fail_if_absent() throws Exception {
        String index = (String)this.indexes.newInstance();
        String key = "name";
        String value = "Peter";
        helper.createRelationshipIndex(index);
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(201).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"uri\":\"" + functionalTestHelper.relationshipUri(helper.createRelationship("KNOWS", helper.createNode(new Label[0]), helper.createNode(new Label[0]))) + "\"}").post(functionalTestHelper.relationshipIndexUri() + index + "?uniqueness=create_or_fail");
    }

    @Documented(value="Add an existing relationship to a unique index (already indexed).")
    @Test
    public void put_relationship_if_absent_only_fail() throws Exception {
        Relationship rel;
        String index = (String)this.indexes.newInstance();
        String key = "name";
        String value = "Peter";
        GraphDatabaseService graphdb = this.graphdb();
        helper.createRelationshipIndex(index);
        try (Transaction tx = graphdb.beginTx();){
            Node node1 = graphdb.createNode();
            Node node2 = graphdb.createNode();
            Relationship rel2 = node1.createRelationshipTo(node2, (RelationshipType)MyRelationshipTypes.KNOWS);
            graphdb.index().forRelationships(index).add((PropertyContainer)rel2, "name", (Object)"Peter");
            tx.success();
        }
        try (Transaction tx = graphdb.beginTx();){
            Node node1 = graphdb.createNode();
            Node node2 = graphdb.createNode();
            rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelationshipTypes.KNOWS);
            tx.success();
        }
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(409).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"uri\":\"" + functionalTestHelper.relationshipUri(rel.getId()) + "\"}").post(functionalTestHelper.relationshipIndexUri() + index + "?uniqueness=create_or_fail");
    }

    @Test
    public void already_indexed_relationship_should_not_fail_on_create_or_fail() throws Exception {
        Relationship rel;
        String index = (String)this.indexes.newInstance();
        String key = "name";
        String value = "Peter";
        GraphDatabaseService graphdb = this.graphdb();
        helper.createRelationshipIndex(index);
        try (Transaction tx = graphdb.beginTx();){
            Node node1 = graphdb.createNode();
            Node node2 = graphdb.createNode();
            rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelationshipTypes.KNOWS);
            graphdb.index().forRelationships(index).add((PropertyContainer)rel, "name", (Object)"Peter");
            tx.success();
        }
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(201).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"uri\":\"" + functionalTestHelper.relationshipUri(rel.getId()) + "\"}").post(functionalTestHelper.relationshipIndexUri() + index + "?uniqueness=create_or_fail");
    }

    @Test
    public void createUniqueShouldBeBackwardsCompatibleWith1_8() throws Exception {
        String index = (String)this.indexes.newInstance();
        String key = "name";
        String value = "Peter";
        GraphDatabaseService graphdb = this.graphdb();
        helper.createRelationshipIndex(index);
        try (Transaction tx = graphdb.beginTx();){
            Node node1 = graphdb.createNode();
            Node node2 = graphdb.createNode();
            Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelationshipTypes.KNOWS);
            graphdb.index().forRelationships(index).add((PropertyContainer)rel, "name", (Object)"Peter");
            tx.success();
        }
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"start\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"end\": \"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\", \"type\":\"" + (Object)((Object)MyRelationshipTypes.KNOWS) + "\"}").post(functionalTestHelper.relationshipIndexUri() + index + "?unique");
    }

    private JaxRsResponse httpPostIndexRelationshipRoot(String jsonIndexSpecification) {
        return RestRequest.req().post(functionalTestHelper.relationshipIndexUri(), jsonIndexSpecification);
    }

    private JaxRsResponse httpGetIndexRelationshipNameKeyValue(String indexName, String key, String value) {
        return RestRequest.req().get(functionalTestHelper.indexRelationshipUri(indexName, key, value));
    }

    private JaxRsResponse httpPostIndexRelationshipNameKeyValue(String indexName, long relationshipId, String key, String value) {
        return RestRequest.req().post(functionalTestHelper.indexRelationshipUri(indexName), this.createJsonStringFor(relationshipId, key, value));
    }

    private String createJsonStringFor(long relationshipId, String key, String value) {
        return "{\"key\": \"" + key + "\", \"value\": \"" + value + "\", \"uri\": \"" + functionalTestHelper.relationshipUri(relationshipId) + "\"}";
    }

    private JaxRsResponse httpGet(String indexUri) {
        return request.get(indexUri);
    }

    private JaxRsResponse httpPostCreateRelationship(long startNode, String jsonString) {
        return RestRequest.req().post(functionalTestHelper.dataUri() + "node/" + startNode + "/relationships", jsonString);
    }

    private String jsonRelationshipCreationSpecification(String relationshipName, long endNode, String key, String value) {
        return "{\"to\" : \"" + functionalTestHelper.dataUri() + "node/" + endNode + "\"," + "\"type\" : \"" + relationshipName + "\", " + "\"data\" : {\"" + key + "\" : \"" + value + "\"}}";
    }

    private static enum MyRelationshipTypes implements RelationshipType
    {
        KNOWS;

    }
}

