/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;

public class GetIndexRootDocIT
extends AbstractRestFunctionalTestBase {
    private static FunctionalTestHelper functionalTestHelper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(GetIndexRootDocIT.server());
    }

    @Test
    public void shouldRespondWith404ForNonResourceIndexPath() throws Exception {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.indexUri());
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void shouldRespondWithNodeIndexes() throws Exception {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.nodeIndexUri());
        this.assertResponseContainsNoIndexesOtherThanAutoIndexes(response);
        response.close();
    }

    private void assertResponseContainsNoIndexesOtherThanAutoIndexes(JaxRsResponse response) throws JsonParseException {
        switch (response.getStatus()) {
            case 204: {
                return;
            }
            case 200: {
                Assert.assertEquals((long)0L, (long)functionalTestHelper.removeAnyAutoIndex(JsonHelper.jsonToMap((String)response.getEntity())).size());
                break;
            }
            default: {
                Assert.fail((String)("Invalid response code " + response.getStatus()));
            }
        }
    }

    @Test
    public void shouldRespondWithRelationshipIndexes() throws Exception {
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.relationshipIndexUri());
        this.assertResponseContainsNoIndexesOtherThanAutoIndexes(response);
        response.close();
    }
}

