/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightTask;
import org.neo4j.test.SuppressOutput;

public class TestPreflightTasks {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void shouldPassWithNoRules() {
        PreFlightTasks check = new PreFlightTasks((LogProvider)NullLogProvider.getInstance(), new PreflightTask[0]);
        Assert.assertTrue((boolean)check.run());
    }

    @Test
    public void shouldRunAllHealthChecksToCompletionIfNonFail() {
        PreFlightTasks check = new PreFlightTasks((LogProvider)NullLogProvider.getInstance(), this.getPassingRules());
        Assert.assertTrue((boolean)check.run());
    }

    @Test
    public void shouldFailIfOneOrMoreHealthChecksFail() {
        PreFlightTasks check = new PreFlightTasks((LogProvider)NullLogProvider.getInstance(), this.getWithOneFailingRule());
        Assert.assertFalse((boolean)check.run());
    }

    @Test
    public void shouldLogFailedRule() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        PreFlightTasks check = new PreFlightTasks((LogProvider)logProvider, this.getWithOneFailingRule());
        check.run();
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(PreFlightTasks.class).error("blah blah")});
    }

    @Test
    public void shouldAdvertiseFailedRule() {
        PreFlightTasks check = new PreFlightTasks((LogProvider)NullLogProvider.getInstance(), this.getWithOneFailingRule());
        check.run();
        Assert.assertNotNull((Object)check.failedTask());
    }

    private PreflightTask[] getWithOneFailingRule() {
        PreflightTask[] rules = new PreflightTask[5];
        for (int i = 0; i < rules.length; ++i) {
            rules[i] = new PreflightTask(){

                public boolean run() {
                    return true;
                }

                public String getFailureMessage() {
                    return "blah blah";
                }
            };
        }
        rules[rules.length / 2] = new PreflightTask(){

            public boolean run() {
                return false;
            }

            public String getFailureMessage() {
                return "blah blah";
            }
        };
        return rules;
    }

    private PreflightTask[] getPassingRules() {
        PreflightTask[] rules = new PreflightTask[5];
        for (int i = 0; i < rules.length; ++i) {
            rules[i] = new PreflightTask(){

                public boolean run() {
                    return true;
                }

                public String getFailureMessage() {
                    return "blah blah";
                }
            };
        }
        return rules;
    }
}

