/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.cache.ArrayDescriptor;
import org.nd4j.linalg.cache.BasicConstantHandler;
import org.nd4j.linalg.factory.Nd4j;

public class ConstantBuffersCache
extends BasicConstantHandler {
    protected Map<ArrayDescriptor, DataBuffer> buffersCache = new ConcurrentHashMap<ArrayDescriptor, DataBuffer>();
    private AtomicInteger counter = new AtomicInteger(0);
    private AtomicLong bytes = new AtomicLong(0L);
    private static final int MAX_ENTRIES = 1000;

    public DataBuffer getConstantBuffer(int[] array) {
        ArrayDescriptor descriptor = new ArrayDescriptor(array);
        if (!this.buffersCache.containsKey(descriptor)) {
            DataBuffer buffer = Nd4j.createBufferDetached((int[])array);
            if (this.counter.get() < 1000 || array.length < 4) {
                this.counter.incrementAndGet();
                this.buffersCache.put(descriptor, buffer);
                this.bytes.addAndGet(array.length * 4);
            }
            return buffer;
        }
        return this.buffersCache.get(descriptor);
    }

    public void purgeConstants() {
        this.buffersCache = new ConcurrentHashMap<ArrayDescriptor, DataBuffer>();
    }

    public DataBuffer getConstantBuffer(float[] array) {
        ArrayDescriptor descriptor = new ArrayDescriptor(array);
        if (!this.buffersCache.containsKey(descriptor)) {
            DataBuffer buffer = Nd4j.createBufferDetached((float[])array);
            if (this.counter.get() < 1000) {
                this.counter.incrementAndGet();
                this.buffersCache.put(descriptor, buffer);
                this.bytes.addAndGet(array.length * Nd4j.sizeOfDataType());
            }
            return buffer;
        }
        return this.buffersCache.get(descriptor);
    }

    public DataBuffer getConstantBuffer(double[] array) {
        ArrayDescriptor descriptor = new ArrayDescriptor(array);
        if (!this.buffersCache.containsKey(descriptor)) {
            DataBuffer buffer = Nd4j.createBufferDetached((double[])array);
            if (this.counter.get() < 1000) {
                this.counter.incrementAndGet();
                this.buffersCache.put(descriptor, buffer);
                this.bytes.addAndGet(array.length * Nd4j.sizeOfDataType());
            }
            return buffer;
        }
        return this.buffersCache.get(descriptor);
    }

    public DataBuffer getConstantBuffer(long[] array) {
        ArrayDescriptor descriptor = new ArrayDescriptor(array);
        if (!this.buffersCache.containsKey(descriptor)) {
            DataBuffer buffer = Nd4j.createBufferDetached((long[])array);
            if (this.counter.get() < 1000) {
                this.counter.incrementAndGet();
                this.buffersCache.put(descriptor, buffer);
                this.bytes.addAndGet(array.length * Nd4j.sizeOfDataType());
            }
            return buffer;
        }
        return this.buffersCache.get(descriptor);
    }

    public long getCachedBytes() {
        return this.bytes.get();
    }
}

