/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc.logging;

import com.mongodb.jdbc.logging.LoggingAspect;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class MongoLogger {
    private static final String ENTRY_PREFIX = ">> ";
    private Logger logger;
    private Integer connectionId;
    private Integer statementId;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public MongoLogger(Logger logger, int connectionId) {
        this.logger = logger;
        this.connectionId = connectionId;
    }

    public MongoLogger(String className, MongoLogger parentLogger, int statementId) {
        this.createLogger(className, parentLogger);
        this.statementId = statementId;
    }

    public MongoLogger(String className, MongoLogger parentLogger) {
        this.createLogger(className, parentLogger);
    }

    private void createLogger(String className, MongoLogger parentLogger) {
        try {
            String loggername = parentLogger.connectionId == null ? className : parentLogger.connectionId + "_" + className;
            this.logger = Logger.getLogger(loggername);
            this.logger.setParent(parentLogger.logger);
            this.logger.setLevel(parentLogger.logger.getLevel());
            this.logger.setUseParentHandlers(true);
            this.connectionId = parentLogger.connectionId;
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    protected void logMethodEntry(String sourceName, String callSignature) {
        try {
            if (this.logger != null && this.logger.isLoggable(Level.FINER)) {
                this.logger.logp(Level.FINER, this.addConnectionStatementIdsToSourceName(sourceName), null, ENTRY_PREFIX + callSignature);
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    protected void logError(String sourceName, String msg, Throwable thrown) {
        try {
            if (this.logger != null && this.logger.isLoggable(Level.SEVERE)) {
                this.logger.logp(Level.SEVERE, this.addConnectionStatementIdsToSourceName(sourceName), null, msg, thrown);
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    public void log(Level level, String msg) {
        try {
            if (this.logger != null && this.logger.isLoggable(level)) {
                StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
                StackTraceElement ste = stacktrace[2];
                String sourceClassName = ste.getClassName();
                String methodName = ste.getMethodName();
                this.logger.logp(level, this.addConnectionStatementIdsToSourceName(sourceClassName), methodName, msg);
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    public void log(Level level, String msg, Object[] params) {
        try {
            if (this.logger != null && this.logger.isLoggable(level)) {
                StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
                StackTraceElement ste = stacktrace[2];
                String sourceClassName = ste.getClassName();
                String methodName = ste.getMethodName();
                this.logger.logp(level, this.addConnectionStatementIdsToSourceName(sourceClassName), methodName, msg, params);
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        try {
            if (this.logger != null && this.logger.isLoggable(level)) {
                StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
                StackTraceElement ste = stacktrace[2];
                String sourceClassName = ste.getClassName();
                String methodName = ste.getMethodName();
                this.logger.logp(level, this.addConnectionStatementIdsToSourceName(sourceClassName), methodName, msg, thrown);
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    protected String addConnectionStatementIdsToSourceName(String sourceName) {
        try {
            if (this.statementId != null) {
                sourceName = "[stmt-" + this.statementId + "] " + sourceName;
            }
            if (this.connectionId != null) {
                sourceName = "[c-" + this.connectionId + "] " + sourceName;
            }
            return sourceName;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    static {
        MongoLogger.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoLogger.java", MongoLogger.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createLogger", "com.mongodb.jdbc.logging.MongoLogger", "java.lang.String:com.mongodb.jdbc.logging.MongoLogger", "className:parentLogger", "", "void"), 70);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "logMethodEntry", "com.mongodb.jdbc.logging.MongoLogger", "java.lang.String:java.lang.String", "sourceName:callSignature", "", "void"), 92);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "logError", "com.mongodb.jdbc.logging.MongoLogger", "java.lang.String:java.lang.String:java.lang.Throwable", "sourceName:msg:thrown", "", "void"), 102);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "log", "com.mongodb.jdbc.logging.MongoLogger", "java.util.logging.Level:java.lang.String", "level:msg", "", "void"), 122);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "log", "com.mongodb.jdbc.logging.MongoLogger", "java.util.logging.Level:java.lang.String:[Ljava.lang.Object;", "level:msg:params", "", "void"), 145);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "log", "com.mongodb.jdbc.logging.MongoLogger", "java.util.logging.Level:java.lang.String:java.lang.Throwable", "level:msg:thrown", "", "void"), 176);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "addConnectionStatementIdsToSourceName", "com.mongodb.jdbc.logging.MongoLogger", "java.lang.String", "sourceName", "", "java.lang.String"), 199);
    }
}

