/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.client.AsyncDistinctIterable;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import com.mongodb.reactivestreams.client.internal.Publishers;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class DistinctPublisherImpl<TResult>
implements DistinctPublisher<TResult> {
    private final AsyncDistinctIterable<TResult> wrapped;

    DistinctPublisherImpl(AsyncDistinctIterable<TResult> wrapped) {
        this.wrapped = (AsyncDistinctIterable)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public DistinctPublisher<TResult> filter(Bson filter) {
        this.wrapped.filter(filter);
        return this;
    }

    @Override
    public DistinctPublisher<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public DistinctPublisher<TResult> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    @Override
    public DistinctPublisher<TResult> batchSize(int batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    @Override
    public Publisher<TResult> first() {
        return Publishers.publish(arg_0 -> this.wrapped.first(arg_0));
    }

    public void subscribe(Subscriber<? super TResult> s) {
        Publishers.publish(this.wrapped).subscribe(s);
    }
}

